import { MenusService } from 'src/menus/menus.service';
import { PermissionsService } from 'src/permissions/permissions.service';
import { UserPermissionsService } from 'src/user-permissions/user-permissions.service';
import { AccountService } from './account.service';
import { CreateAccountDto, PaginationDto, StatusDto, PasswordDto, PasswordWithOldDto } from './dto/account.dto';
import { Account } from './entities/account.entity';
export declare class AccountController {
    private readonly accountService;
    private readonly menuService;
    private readonly permissionService;
    private readonly userPermService;
    constructor(accountService: AccountService, menuService: MenusService, permissionService: PermissionsService, userPermService: UserPermissionsService);
    create(dto: CreateAccountDto, user: Account): Promise<any>;
    find(query: PaginationDto, user: Account): Promise<{
        result: Account[];
        total: number;
    }>;
    findById(query: PaginationDto, id: string): Promise<{
        result: Account[];
        total: number;
    }>;
    outletProfile(user: Account): Promise<Account>;
    profile(user: Account): Promise<Account>;
    findAll(query: PaginationDto): Promise<{
        result: Account[];
        total: number;
    }>;
    findOne(id: string): Promise<Account>;
    updateOwnPassword(dto: PasswordWithOldDto, user: Account): Promise<Account & {
        password: any;
        passwordShow: string;
    }>;
    updatePassword(dto: PasswordDto, id: string): Promise<Account & {
        password: any;
        passwordShow: string;
    }>;
    status(id: string, dto: StatusDto): Promise<Account & StatusDto>;
    remove(id: string): Promise<Account>;
}
