import { HttpService } from '@nestjs/axios';
import { JwtService } from '@nestjs/jwt';
import { Cache } from 'cache-manager';
import { Account } from 'src/account/entities/account.entity';
import { UserRole } from 'src/enum';
import { LoginHistory } from 'src/login-history/entities/login-history.entity';
import { NotifyService } from 'src/notify/notify.service';
import { UserPermission } from 'src/user-permissions/entities/user-permission.entity';
import { Repository } from 'typeorm';
import { MobLoginDto, PassDto } from './dto/login.dto';
export declare class AuthService {
    private jwtService;
    private readonly repo;
    private readonly logRepo;
    private readonly upRepo;
    private readonly httpService;
    private cacheManager;
    private readonly notifyService;
    constructor(jwtService: JwtService, repo: Repository<Account>, logRepo: Repository<LoginHistory>, upRepo: Repository<UserPermission>, httpService: HttpService, cacheManager: Cache, notifyService: NotifyService);
    mobLogin(dto: MobLoginDto, ip: string, origin?: string): Promise<{
        token: string;
        type: UserRole;
        pass: string;
    }>;
    signIn(loginId: string, password: string, ip: string, origin?: string): Promise<{
        token: string;
        admin: any;
    }>;
    logout(accountId: string, browser: string, ip: string): Promise<any>;
    validate(id: string, deviceId: string): Promise<any>;
    findPermission(accountId: string): Promise<any>;
    private getPermissions;
    private getUserDetails;
    calculateDistance(lat1: any, lon1: any, lat2: any, lon2: any): number;
    find(dto: PassDto, password: any): Promise<{
        result: {
            message: boolean;
            statusCode: number;
        };
    }>;
}
