"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthService = void 0;
const axios_1 = require("@nestjs/axios");
const cache_manager_1 = require("@nestjs/cache-manager");
const common_1 = require("@nestjs/common");
const jwt_1 = require("@nestjs/jwt");
const typeorm_1 = require("@nestjs/typeorm");
const bcrypt = require("bcrypt");
const account_entity_1 = require("../account/entities/account.entity");
const enum_1 = require("../enum");
const login_history_entity_1 = require("../login-history/entities/login-history.entity");
const notify_service_1 = require("../notify/notify.service");
const user_permission_entity_1 = require("../user-permissions/entities/user-permission.entity");
const apiFeatures_utils_1 = require("../utils/apiFeatures.utils");
const typeorm_2 = require("typeorm");
let AuthService = class AuthService {
    constructor(jwtService, repo, logRepo, upRepo, httpService, cacheManager, notifyService) {
        this.jwtService = jwtService;
        this.repo = repo;
        this.logRepo = logRepo;
        this.upRepo = upRepo;
        this.httpService = httpService;
        this.cacheManager = cacheManager;
        this.notifyService = notifyService;
        this.getPermissions = async (accountId) => {
            let result = await this.cacheManager.get('userPermission' + accountId);
            if (!result) {
                result = await this.upRepo.find({
                    relations: ['permission', 'menu'],
                    where: { accountId, status: true },
                });
                this.cacheManager.set('userPermission' + accountId, result, 7 * 24 * 60 * 60 * 1000);
            }
            return result;
        };
        this.getUserDetails = async (id) => {
            return this.repo
                .createQueryBuilder('account')
                .leftJoinAndSelect('account.outletDetail', 'outletDetail')
                .select([
                'account.id',
                'account.password',
                'account.roles',
                'account.status',
                'account.createdBy',
                'account.deviceId',
                'account.fcm',
                'account.settingId',
                'outletDetail.id',
            ])
                .andWhere('account.id = :id OR account.loginId = :loginId', {
                id: id,
                loginId: id,
            })
                .getOne();
        };
    }
    async mobLogin(dto, ip, origin) {
        if (dto.type == 'outlet') {
            const user = await this.repo.findOne({
                relations: ['outletDetail'],
                where: [
                    { loginId: dto.loginId, roles: enum_1.UserRole.SUB_OUTLET }
                ],
            });
            if (!user) {
                throw new common_1.UnauthorizedException('Invalid Credentials!');
            }
            const comparePassword = await bcrypt.compare(dto.password, user.password);
            if (!comparePassword) {
                if (user.wrongCount > 5) {
                    this.repo
                        .createQueryBuilder()
                        .update()
                        .set({ status: enum_1.DefaultStatus.SUSPENDED })
                        .where('id = :id', { id: user.id })
                        .execute();
                    throw new common_1.PreconditionFailedException('Account suspended please contact to admin!');
                }
                this.repo
                    .createQueryBuilder()
                    .update()
                    .set({
                    wrongCount: () => 'wrongCount + ' + 1,
                })
                    .where('id = :id', { id: user.id })
                    .execute();
                throw new common_1.UnauthorizedException('Invalid Credentials');
            }
            if (user.outletDetail[0].type === enum_1.OutletType.IN_LOCATION) {
                const distance = await this.calculateDistance(user.outletDetail[0].latitude, user.outletDetail[0].longitude, dto.latitude, dto.longitude);
                if (distance > 100) {
                    this.notifyService.outOfLocationNotify(dto.fcm, user.id);
                    throw new common_1.NotAcceptableException('Out of place login!');
                }
            }
            if (user.status !== enum_1.DefaultStatus.ACTIVE) {
                this.notifyService.loginBlockedNotify(dto.fcm, user.id);
                throw new common_1.ServiceUnavailableException('Account ' + user.status + '. Please contact to admin.');
            }
            this.notifyService.loginNotify(dto.fcm, user.id);
            const deviceObj = Object.assign(user, {
                deviceId: dto.deviceId,
                fcm: dto.fcm,
                wrongCount: user.wrongCount + 1,
            });
            this.repo.save(deviceObj);
            const obj = Object.create({
                ip: ip,
                origin: origin,
                type: enum_1.LogType.LOGIN,
                accountId: user.id,
                latitude: dto.latitude,
                longitude: dto.longitude,
                deviceId: dto.deviceId,
            });
            await this.logRepo.save(obj);
            const token = await apiFeatures_utils_1.default.assignJwtToken(user.id, dto.deviceId, this.jwtService);
            return { token, type: user.roles, pass: user.passwordShow };
        }
        else {
            const user = await this.repo.findOne({
                relations: ['outletDetail'],
                where: [
                    { loginId: dto.loginId, roles: enum_1.UserRole.DELIVERY_BOY }
                ],
            });
            if (!user) {
                throw new common_1.UnauthorizedException('Invalid Credentials!');
            }
            const comparePassword = await bcrypt.compare(dto.password, user.password);
            if (!comparePassword) {
                if (user.wrongCount > 5) {
                    this.repo
                        .createQueryBuilder()
                        .update()
                        .set({ status: enum_1.DefaultStatus.SUSPENDED })
                        .where('id = :id', { id: user.id })
                        .execute();
                    throw new common_1.PreconditionFailedException('Account suspended please contact to admin!');
                }
                this.repo
                    .createQueryBuilder()
                    .update()
                    .set({
                    wrongCount: () => 'wrongCount + ' + 1,
                })
                    .where('id = :id', { id: user.id })
                    .execute();
                throw new common_1.UnauthorizedException('Invalid Credentials');
            }
            if (user.status !== enum_1.DefaultStatus.ACTIVE) {
                this.notifyService.loginBlockedNotify(dto.fcm, user.id);
                throw new common_1.ServiceUnavailableException('Account ' + user.status + '. Please contact to admin.');
            }
            this.notifyService.loginDeliveryBoyNotify(dto.fcm, user.id);
            const deviceObj = Object.assign(user, {
                deviceId: dto.deviceId,
                fcm: dto.fcm,
                wrongCount: user.wrongCount + 1,
            });
            this.repo.save(deviceObj);
            const obj = Object.create({
                ip: ip,
                origin: origin,
                type: enum_1.LogType.LOGIN,
                accountId: user.id,
                latitude: dto.latitude,
                longitude: dto.longitude,
                deviceId: dto.deviceId,
            });
            await this.logRepo.save(obj);
            const token = await apiFeatures_utils_1.default.assignJwtToken(user.id, dto.deviceId, this.jwtService);
            return { token, type: user.roles, pass: user.passwordShow };
        }
    }
    async signIn(loginId, password, ip, origin) {
        const admin = await this.getUserDetails(loginId);
        const comparePassword = await bcrypt.compare(password, admin.password);
        if (!comparePassword) {
            throw new common_1.UnauthorizedException('Invalid Credentials');
        }
        const token = await apiFeatures_utils_1.default.assignJwtToken(admin.id, '1', this.jwtService);
        const obj = Object.create({
            ip: ip,
            origin: origin,
            type: enum_1.LogType.LOGIN,
            accountId: admin.id,
        });
        await this.logRepo.save(obj);
        return { token, admin };
    }
    async logout(accountId, browser, ip) {
        const obj = Object.create({
            ip: ip,
            type: enum_1.LogType.LOGOUT,
            accountId: accountId,
        });
        return this.logRepo.save(obj);
    }
    validate(id, deviceId) {
        if (deviceId == '1') {
            return this.getUserDetails(id);
        }
        else {
            return this.repo
                .createQueryBuilder('account')
                .leftJoinAndSelect('account.outletDetail', 'outletDetail')
                .leftJoinAndSelect('outletDetail.outletBranch', 'outletBranch')
                .select([
                'account.id',
                'account.password',
                'account.roles',
                'account.status',
                'account.createdBy',
                'account.deviceId',
                'account.fcm',
                'account.settingId',
                'outletDetail.id',
                'outletBranch.id',
            ])
                .andWhere('account.id = :id AND account.deviceId = :deviceId', {
                id: id,
                deviceId: deviceId,
            })
                .getOne();
        }
    }
    findPermission(accountId) {
        return this.getPermissions(accountId);
    }
    calculateDistance(lat1, lon1, lat2, lon2) {
        const earthRadius = 6371e3;
        const lat1Rad = lat1 * (Math.PI / 180);
        const lon1Rad = lon1 * (Math.PI / 180);
        const lat2Rad = lat2 * (Math.PI / 180);
        const lon2Rad = lon2 * (Math.PI / 180);
        const deltaLat = lat2Rad - lat1Rad;
        const deltaLon = lon2Rad - lon1Rad;
        const a = Math.sin(deltaLat / 2) * Math.sin(deltaLat / 2) +
            Math.cos(lat1Rad) *
                Math.cos(lat2Rad) *
                Math.sin(deltaLon / 2) *
                Math.sin(deltaLon / 2);
        const c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
        const distance = earthRadius * c;
        return distance;
    }
    async find(dto, password) {
        const comparePassword = await bcrypt.compare(dto.password, password);
        if (!comparePassword) {
            return { "result": {
                    "message": false,
                    "statusCode": 401
                } };
        }
        else {
            return { "result": {
                    "message": true,
                    "statusCode": 200
                } };
        }
    }
};
AuthService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectRepository)(account_entity_1.Account)),
    __param(2, (0, typeorm_1.InjectRepository)(login_history_entity_1.LoginHistory)),
    __param(3, (0, typeorm_1.InjectRepository)(user_permission_entity_1.UserPermission)),
    __param(5, (0, common_1.Inject)(cache_manager_1.CACHE_MANAGER)),
    __metadata("design:paramtypes", [jwt_1.JwtService,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        axios_1.HttpService, Object, notify_service_1.NotifyService])
], AuthService);
exports.AuthService = AuthService;
//# sourceMappingURL=auth.service.js.map