import { Repository } from 'typeorm';
import { CategoryDto } from './dto/category.dto';
import { Category } from './entities/category.entity';
import { BoolStatusDto } from 'src/common/dto/bool-status.dto';
export declare class CategoryService {
    private readonly repo;
    constructor(repo: Repository<Category>);
    create(dto: CategoryDto): Promise<any>;
    findAll(limit: number, offset: number, keyword: string, status: boolean): Promise<{
        result: Category[];
        total: number;
    }>;
    find(limit: number, offset: number, keyword: string): Promise<{
        result: Category[];
        total: number;
    }>;
    findOne(id: string): Promise<Category>;
    update(id: string, dto: CategoryDto): Promise<Category & {
        name: string;
    }>;
    image(image: string, result: Category): Promise<Category & {
        image: string;
        imageName: string;
    }>;
    status(id: string, dto: BoolStatusDto): Promise<Category & BoolStatusDto>;
}
