import { Repository } from 'typeorm';
import { CityDto } from './dto/city.dto';
import { City } from './entities/city.entity';
import { BoolStatusDto } from 'src/common/dto/bool-status.dto';
export declare class CityService {
    private readonly repo;
    constructor(repo: Repository<City>);
    create(dto: CityDto): Promise<any>;
    findAll(limit: number, offset: number, keyword: string, status: boolean, stateId: number): Promise<{
        result: City[];
        total: number;
    }>;
    find(limit: number, offset: number, keyword: string, stateId: number): Promise<{
        result: City[];
        total: number;
    }>;
    findOne(id: number): Promise<City>;
    update(id: number, dto: CityDto): Promise<City & {
        name: string;
    }>;
    status(id: number, dto: BoolStatusDto): Promise<City & BoolStatusDto>;
}
