/// <reference types="multer" />
import { Account } from 'src/account/entities/account.entity';
import { CompanyDetailsService } from './company-details.service';
import { BusinessDetailDto, CompanyDetailDto, PaginationDto, PaginationSDto, StatusDto } from './dto/company-detail.dto';
export declare class CompanyDetailsController {
    private readonly companyDetailsService;
    constructor(companyDetailsService: CompanyDetailsService);
    create(dto: BusinessDetailDto, user: Account): Promise<any>;
    findInfo(user: Account): Promise<import("./entities/company-detail.entity").CompanyDetail>;
    Info(id: string): Promise<import("./entities/company-detail.entity").CompanyDetail>;
    findList(dto: PaginationDto): Promise<{
        result: import("./entities/company-detail.entity").CompanyDetail[];
        total: number;
    }>;
    findAll(dto: PaginationSDto): Promise<{
        result: import("./entities/company-detail.entity").CompanyDetail[];
        total: number;
    }>;
    findOne(id: string): Promise<import("./entities/company-detail.entity").CompanyDetail>;
    update(id: string, dto: CompanyDetailDto): Promise<import("./entities/company-detail.entity").CompanyDetail & CompanyDetailDto>;
    file(id: string, file: Express.Multer.File): Promise<import("./entities/company-detail.entity").CompanyDetail & {
        file: string;
        filePath: string;
    }>;
    logo(id: string, file: Express.Multer.File): Promise<import("./entities/company-detail.entity").CompanyDetail & {
        logo: string;
        logoPath: string;
    }>;
    status(id: string, dto: StatusDto): Promise<import("./entities/company-detail.entity").CompanyDetail & StatusDto>;
}
