"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompanyDetailsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const enum_1 = require("../enum");
const typeorm_2 = require("typeorm");
const company_detail_entity_1 = require("./entities/company-detail.entity");
let CompanyDetailsService = class CompanyDetailsService {
    constructor(repo) {
        this.repo = repo;
    }
    async create(dto) {
        const result = await this.repo.findOne({
            where: { businessName: dto.businessName },
        });
        if (result) {
            throw new common_1.ConflictException('Company with same name already exists!');
        }
        const obj = Object.create(dto);
        return this.repo.save(obj);
    }
    async findAll(dto) {
        const keyword = dto.keyword || '';
        const [result, total] = await this.repo
            .createQueryBuilder('companyDetail')
            .leftJoinAndSelect('companyDetail.state', 'state')
            .leftJoinAndSelect('companyDetail.city', 'city')
            .where('companyDetail.status = :status', {
            status: dto.status,
        })
            .andWhere(new typeorm_2.Brackets((qb) => {
            qb.where('companyDetail.businessName LIKE :businessName OR companyDetail.email LIKE :email', {
                businessName: '%' + keyword + '%',
                email: '%' + keyword + '%',
            });
        }))
            .skip(dto.offset)
            .take(dto.limit)
            .orderBy({ 'companyDetail.businessName': 'ASC' })
            .getManyAndCount();
        return { result, total };
    }
    async findList(dto) {
        const category = JSON.parse(dto.category);
        const subcategory = JSON.parse(dto.subCategory);
        const keyword = dto.keyword || '';
        const query = this.repo
            .createQueryBuilder('companyDetail')
            .leftJoinAndSelect('companyDetail.state', 'state')
            .leftJoinAndSelect('companyDetail.city', 'city')
            .leftJoinAndSelect('companyDetail.companyCategory', 'companyCategory')
            .leftJoinAndSelect('companyDetail.companySubCategory', 'companySubCategory')
            .leftJoinAndSelect('companySubCategory.subCategory', 'subCategory')
            .leftJoinAndSelect('companyCategory.category', 'category')
            .select([
            'companyDetail.id',
            'companyDetail.businessName',
            'companyDetail.personName',
            'companyDetail.logo',
            'state.id',
            'state.name',
            'city.id',
            'city.name',
            'companyCategory.id',
            'category.id',
            'category.name',
            'companySubCategory.id',
            'subCategory.id',
            'subCategory.name',
        ])
            .where('companyDetail.status = :status', {
            status: enum_1.CompanyStatus.APPROVED,
        });
        if (category.length > 0) {
            query.andWhere('category.id IN :categorys', { categorys: category });
        }
        if (subcategory.length > 0) {
            query.andWhere('subCategory.id IN :subCategorys', {
                subCategorys: subcategory,
            });
        }
        query.andWhere(new typeorm_2.Brackets((qb) => {
            qb.where('companyDetail.businessName LIKE :businessName', {
                businessName: '%' + keyword + '%',
            });
        }));
        const [result, total] = await query
            .skip(dto.offset)
            .take(dto.limit)
            .orderBy({ 'companyDetail.businessName': 'ASC' })
            .getManyAndCount();
        return { result, total };
    }
    async findCompany(id) {
        const result = await this.repo
            .createQueryBuilder('companyDetail')
            .where('companyDetail.accountId = :accountId', { accountId: id })
            .getOne();
        if (!result) {
            throw new common_1.NotFoundException('Company not found!');
        }
        return result;
    }
    async findOne(id) {
        const result = await this.repo
            .createQueryBuilder('companyDetail')
            .leftJoinAndSelect('companyDetail.companyCategory', 'companyCategory')
            .leftJoinAndSelect('companyDetail.account', 'account')
            .leftJoinAndSelect('companyDetail.state', 'state')
            .leftJoinAndSelect('companyDetail.city', 'city')
            .leftJoinAndSelect('companyCategory.category', 'category')
            .leftJoinAndSelect('companyDetail.companySubCategory', 'companySubCategory')
            .leftJoinAndSelect('companySubCategory.subCategory', 'subCategory')
            .where('companyDetail.id = :id', { id: id })
            .getOne();
        if (!result) {
            throw new common_1.NotFoundException('Company not found!');
        }
        return result;
    }
    async info(id) {
        const result = await this.repo
            .createQueryBuilder('companyDetail')
            .leftJoinAndSelect('companyDetail.state', 'state')
            .leftJoinAndSelect('companyDetail.city', 'city')
            .leftJoinAndSelect('companyDetail.companyCategory', 'companyCategory')
            .leftJoinAndSelect('companyDetail.companySubCategory', 'companySubCategory')
            .leftJoinAndSelect('companySubCategory', 'subCategory')
            .leftJoinAndSelect('companyCategory', 'category')
            .select([
            'companyDetail.id',
            'companyDetail.businessName',
            'companyDetail.personName',
            'companyDetail.logo',
            'companyDetail.desc',
            'state.id',
            'state.name',
            'city.id',
            'city.name',
            'companyCategory.id',
            'category.id',
            'category.name',
            'companySubCategory.id',
            'subCategory.id',
            'subCategory.name',
        ])
            .where('companyDetail.status = :status AND companyDetail.accountId = :accountId', {
            status: enum_1.CompanyStatus.APPROVED,
            accountId: id,
        })
            .getOne();
        if (!result) {
            throw new common_1.NotFoundException('Company not found!');
        }
        return result;
    }
    async update(id, dto) {
        const result = await this.repo.findOne({ where: { id } });
        if (!result) {
            throw new common_1.NotFoundException('Company not found!');
        }
        const obj = Object.assign(result, dto);
        return this.repo.save(obj);
    }
    async file(id, image) {
        const result = await this.repo.findOne({ where: { id } });
        if (!result) {
            throw new common_1.NotFoundException('Company detail not found!');
        }
        const obj = Object.assign(result, {
            file: process.env.CDN_LINK + image,
            filePath: image,
        });
        return this.repo.save(obj);
    }
    async logo(id, image) {
        const result = await this.repo.findOne({ where: { id } });
        if (!result) {
            throw new common_1.NotFoundException('Company detail not found!');
        }
        const obj = Object.assign(result, {
            logo: process.env.CDN_LINK + image,
            logoPath: image,
        });
        return this.repo.save(obj);
    }
    async status(id, dto) {
        const result = await this.repo.findOne({ where: { id } });
        if (!result) {
            throw new common_1.NotFoundException('Company detail not found!');
        }
        const obj = Object.assign(result, dto);
        return this.repo.save(obj);
    }
};
CompanyDetailsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(company_detail_entity_1.CompanyDetail)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], CompanyDetailsService);
exports.CompanyDetailsService = CompanyDetailsService;
//# sourceMappingURL=company-details.service.js.map