import { Repository } from 'typeorm';
import { FeedbackDto, PaginationDto, StatusDto } from './dto/feedback.dto';
import { Feedback } from './entities/feedback.entity';
export declare class FeedbackService {
    private readonly repo;
    constructor(repo: Repository<Feedback>);
    create(dto: FeedbackDto): Promise<any>;
    findAll(dto: PaginationDto): Promise<{
        result: Feedback[];
        total: number;
    }>;
    find(): Promise<Feedback[]>;
    update(id: string, dto: FeedbackDto): Promise<Feedback & FeedbackDto>;
    status(id: string, dto: StatusDto): Promise<Feedback & StatusDto>;
}
