"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const common_1 = require("@nestjs/common");
const core_1 = require("@nestjs/core");
const swagger_1 = require("@nestjs/swagger");
const app_module_1 = require("./app.module");
const fs_1 = require("fs");
async function bootstrap() {
    const httpsOptions = {
        key: (0, fs_1.readFileSync)('ssl/private.pem'),
        cert: (0, fs_1.readFileSync)('ssl/certificate.crt'),
        ca: (0, fs_1.readFileSync)('ssl/sslca.ca-bundle'),
    };
    const app = await core_1.NestFactory.create(app_module_1.AppModule, { httpsOptions });
    app.setGlobalPrefix('api/v1');
    app.useGlobalPipes(new common_1.ValidationPipe({ transform: true }));
    app.enableCors();
    const config = new swagger_1.DocumentBuilder()
        .setTitle('Ambuja Server')
        .setDescription('The Ambuja server API description')
        .setVersion('1.0')
        .addTag('Ambuja Server')
        .addBearerAuth()
        .build();
    const document = swagger_1.SwaggerModule.createDocument(app, config);
    swagger_1.SwaggerModule.setup('api', app, document);
    await app.listen(8000);
}
bootstrap();
//# sourceMappingURL=main.js.map