"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OutletBranch = void 0;
const city_entity_1 = require("../../city/entities/city.entity");
const company_detail_entity_1 = require("../../company-details/entities/company-detail.entity");
const enum_1 = require("../../enum");
const outlet_category_entity_1 = require("../../outlet-category/entities/outlet-category.entity");
const outlet_detail_entity_1 = require("../../outlet-details/entities/outlet-detail.entity");
const outlet_sub_category_entity_1 = require("../../outlet-sub-category/entities/outlet-sub-category.entity");
const state_entity_1 = require("../../state/entities/state.entity");
const typeorm_1 = require("typeorm");
let OutletBranch = class OutletBranch {
};
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)('uuid'),
    __metadata("design:type", String)
], OutletBranch.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'varchar', length: 50, nullable: true }),
    __metadata("design:type", String)
], OutletBranch.prototype, "branchName", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'varchar', length: 50, nullable: true }),
    __metadata("design:type", String)
], OutletBranch.prototype, "contactPersonName", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'varchar', length: 20, nullable: true }),
    __metadata("design:type", String)
], OutletBranch.prototype, "phone", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'varchar', length: 50, nullable: true }),
    __metadata("design:type", String)
], OutletBranch.prototype, "email", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    __metadata("design:type", String)
], OutletBranch.prototype, "logo", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    __metadata("design:type", String)
], OutletBranch.prototype, "logoName", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'enum', enum: enum_1.CompanyStatus, default: enum_1.CompanyStatus.PENDING }),
    __metadata("design:type", String)
], OutletBranch.prototype, "status", void 0);
__decorate([
    (0, typeorm_1.CreateDateColumn)(),
    __metadata("design:type", Date)
], OutletBranch.prototype, "createdAt", void 0);
__decorate([
    (0, typeorm_1.UpdateDateColumn)(),
    __metadata("design:type", Date)
], OutletBranch.prototype, "updatedAt", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'uuid' }),
    __metadata("design:type", String)
], OutletBranch.prototype, "companyDetailId", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'int' }),
    __metadata("design:type", Number)
], OutletBranch.prototype, "cityId", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'int' }),
    __metadata("design:type", Number)
], OutletBranch.prototype, "stateId", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => company_detail_entity_1.CompanyDetail, (companyDetail) => companyDetail.outletBranch, {
        cascade: true,
        onUpdate: 'CASCADE',
        onDelete: 'CASCADE',
    }),
    __metadata("design:type", Array)
], OutletBranch.prototype, "companyDetail", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => outlet_detail_entity_1.OutletDetail, (outletDetail) => outletDetail.outletBranch),
    __metadata("design:type", outlet_detail_entity_1.OutletDetail)
], OutletBranch.prototype, "outletDetail", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => outlet_category_entity_1.OutletCategory, (outletCategory) => outletCategory.outletBranch),
    __metadata("design:type", outlet_category_entity_1.OutletCategory)
], OutletBranch.prototype, "outletCategory", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => outlet_sub_category_entity_1.OutletSubCategory, (outletSubCategory) => outletSubCategory.outletBranch),
    __metadata("design:type", outlet_sub_category_entity_1.OutletSubCategory)
], OutletBranch.prototype, "outletSubCategory", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => state_entity_1.State, (state) => state.outletBranch, {
        cascade: true,
        onUpdate: 'CASCADE',
        onDelete: 'CASCADE',
    }),
    __metadata("design:type", Array)
], OutletBranch.prototype, "state", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => city_entity_1.City, (city) => city.outletBranch, {
        cascade: true,
        onUpdate: 'CASCADE',
        onDelete: 'CASCADE',
    }),
    __metadata("design:type", Array)
], OutletBranch.prototype, "city", void 0);
OutletBranch = __decorate([
    (0, typeorm_1.Entity)()
], OutletBranch);
exports.OutletBranch = OutletBranch;
//# sourceMappingURL=outlet-branch.entity.js.map