"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OutletDetail = void 0;
const account_entity_1 = require("../../account/entities/account.entity");
const area_entity_1 = require("../../area/entities/area.entity");
const city_entity_1 = require("../../city/entities/city.entity");
const enum_1 = require("../../enum");
const order_entity_1 = require("../../orders/entities/order.entity");
const outlet_branch_entity_1 = require("../../outlet-branch/entities/outlet-branch.entity");
const state_entity_1 = require("../../state/entities/state.entity");
const route_master_entity_1 = require("../../route-master/entities/route-master.entity");
const route_assgin_log_entity_1 = require("../../route-assgin-log/entities/route-assgin-log.entity");
const typeorm_1 = require("typeorm");
let OutletDetail = class OutletDetail {
};
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)('uuid'),
    __metadata("design:type", String)
], OutletDetail.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'varchar', length: 50, nullable: true }),
    __metadata("design:type", String)
], OutletDetail.prototype, "outletId", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'varchar', length: 50, nullable: true }),
    __metadata("design:type", String)
], OutletDetail.prototype, "storeName", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'varchar', length: 50, nullable: true }),
    __metadata("design:type", String)
], OutletDetail.prototype, "contactPerson", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'varchar', length: 20, nullable: true }),
    __metadata("design:type", String)
], OutletDetail.prototype, "contact", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'varchar', length: 250, nullable: true }),
    __metadata("design:type", String)
], OutletDetail.prototype, "address", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'varchar', length: 100, nullable: true }),
    __metadata("design:type", String)
], OutletDetail.prototype, "latitude", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'varchar', length: 100, nullable: true }),
    __metadata("design:type", String)
], OutletDetail.prototype, "longitude", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'time', nullable: true }),
    __metadata("design:type", Date)
], OutletDetail.prototype, "storeOpenTime", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'time', nullable: true }),
    __metadata("design:type", Date)
], OutletDetail.prototype, "orderOpenTime", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'time', nullable: true }),
    __metadata("design:type", Date)
], OutletDetail.prototype, "orderCloseTime", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'enum', enum: enum_1.CompanyStatus, default: enum_1.CompanyStatus.PENDING }),
    __metadata("design:type", String)
], OutletDetail.prototype, "status", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'enum', enum: enum_1.OutletType, default: enum_1.OutletType.IN_LOCATION }),
    __metadata("design:type", String)
], OutletDetail.prototype, "type", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'uuid' }),
    __metadata("design:type", String)
], OutletDetail.prototype, "outletBranchId", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'uuid' }),
    __metadata("design:type", String)
], OutletDetail.prototype, "accountId", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'int' }),
    __metadata("design:type", Number)
], OutletDetail.prototype, "areaId", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'int' }),
    __metadata("design:type", Number)
], OutletDetail.prototype, "cityId", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'int' }),
    __metadata("design:type", Number)
], OutletDetail.prototype, "stateId", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'int', nullable: true }),
    __metadata("design:type", Number)
], OutletDetail.prototype, "routeMasterId", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => outlet_branch_entity_1.OutletBranch, (outletBranch) => outletBranch.outletDetail, {
        cascade: true,
        onUpdate: 'CASCADE',
        onDelete: 'CASCADE',
    }),
    __metadata("design:type", Array)
], OutletDetail.prototype, "outletBranch", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => account_entity_1.Account, (account) => account.outletDetail, {
        cascade: true,
        onUpdate: 'CASCADE',
        onDelete: 'CASCADE',
    }),
    __metadata("design:type", Array)
], OutletDetail.prototype, "account", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => state_entity_1.State, (state) => state.outletDetail, {
        cascade: true,
        onUpdate: 'CASCADE',
        onDelete: 'CASCADE',
    }),
    __metadata("design:type", Array)
], OutletDetail.prototype, "state", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => city_entity_1.City, (city) => city.outletDetail, {
        cascade: true,
        onUpdate: 'CASCADE',
        onDelete: 'CASCADE',
    }),
    __metadata("design:type", Array)
], OutletDetail.prototype, "city", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => area_entity_1.Area, (area) => area.outletDetail, {
        cascade: true,
        onUpdate: 'CASCADE',
        onDelete: 'CASCADE',
    }),
    __metadata("design:type", Array)
], OutletDetail.prototype, "area", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => route_master_entity_1.RouteMaster, (routeMaster) => routeMaster.outletDetail, {
        cascade: true,
        onUpdate: 'CASCADE',
        onDelete: 'CASCADE',
    }),
    __metadata("design:type", Array)
], OutletDetail.prototype, "routeMaster", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => order_entity_1.Order, (order) => order.outletDetail),
    __metadata("design:type", Array)
], OutletDetail.prototype, "order", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => route_assgin_log_entity_1.RouteAssginLog, (routeAssginLog) => routeAssginLog.outletDetail),
    __metadata("design:type", Array)
], OutletDetail.prototype, "routeAssginLog", void 0);
OutletDetail = __decorate([
    (0, typeorm_1.Entity)()
], OutletDetail);
exports.OutletDetail = OutletDetail;
//# sourceMappingURL=outlet-detail.entity.js.map