"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OutletDetailsController = void 0;
const common_1 = require("@nestjs/common");
const passport_1 = require("@nestjs/passport");
const account_entity_1 = require("../account/entities/account.entity");
const current_user_decorator_1 = require("../auth/decorators/current-user.decorator");
const permissions_decorator_1 = require("../auth/decorators/permissions.decorator");
const roles_decorator_1 = require("../auth/decorators/roles.decorator");
const permissions_guard_1 = require("../auth/guards/permissions.guard");
const roles_guard_1 = require("../auth/guards/roles.guard");
const enum_1 = require("../enum");
const outlet_branch_dto_1 = require("../outlet-branch/dto/outlet-branch.dto");
const outlet_detail_dto_1 = require("./dto/outlet-detail.dto");
const outlet_details_service_1 = require("./outlet-details.service");
let OutletDetailsController = class OutletDetailsController {
    constructor(outletDetailsService) {
        this.outletDetailsService = outletDetailsService;
    }
    create(createOutletDetailDto, user) {
        return this.outletDetailsService.create(createOutletDetailDto, user.id);
    }
    findAll(dto) {
        return this.outletDetailsService.findAll(dto);
    }
    outletProfile(id) {
        return this.outletDetailsService.outletProfile(id);
    }
    find(dto, branchId) {
        return this.outletDetailsService.find(dto, branchId);
    }
    update(id, updateOutletDetailDto) {
        return this.outletDetailsService.update(id, updateOutletDetailDto);
    }
    status(id, dto) {
        return this.outletDetailsService.status(id, dto);
    }
    timeIncrease(id, dto) {
        return this.outletDetailsService.timeIncrease(id, dto);
    }
};
__decorate([
    (0, common_1.Post)(),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard, permissions_guard_1.PermissionsGuard),
    (0, roles_decorator_1.Roles)(...Object.values(enum_1.UserRole)),
    (0, permissions_decorator_1.CheckPermissions)([enum_1.PermissionAction.CREATE, 'outlet_detail']),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [outlet_detail_dto_1.CreateOutletDetailDto,
        account_entity_1.Account]),
    __metadata("design:returntype", void 0)
], OutletDetailsController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard, permissions_guard_1.PermissionsGuard),
    (0, roles_decorator_1.Roles)(...Object.values(enum_1.UserRole)),
    (0, permissions_decorator_1.CheckPermissions)([enum_1.PermissionAction.READ, 'outlet_detail']),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [outlet_branch_dto_1.PaginationSDto]),
    __metadata("design:returntype", void 0)
], OutletDetailsController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)(':id'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard, permissions_guard_1.PermissionsGuard),
    (0, roles_decorator_1.Roles)(...Object.values(enum_1.UserRole)),
    (0, permissions_decorator_1.CheckPermissions)([enum_1.PermissionAction.READ, 'outlet_detail']),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], OutletDetailsController.prototype, "outletProfile", null);
__decorate([
    (0, common_1.Get)('list/:branchId'),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, common_1.Param)('branchId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [outlet_branch_dto_1.PaginationSDto, String]),
    __metadata("design:returntype", void 0)
], OutletDetailsController.prototype, "find", null);
__decorate([
    (0, common_1.Patch)(':id'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard, permissions_guard_1.PermissionsGuard),
    (0, roles_decorator_1.Roles)(...Object.values(enum_1.UserRole)),
    (0, permissions_decorator_1.CheckPermissions)([enum_1.PermissionAction.UPDATE, 'outlet_detail']),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, outlet_detail_dto_1.OutletDetailDto]),
    __metadata("design:returntype", void 0)
], OutletDetailsController.prototype, "update", null);
__decorate([
    (0, common_1.Put)(':id'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard, permissions_guard_1.PermissionsGuard),
    (0, roles_decorator_1.Roles)(...Object.values(enum_1.UserRole)),
    (0, permissions_decorator_1.CheckPermissions)([enum_1.PermissionAction.UPDATE, 'outlet_detail']),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, outlet_branch_dto_1.StatusDto]),
    __metadata("design:returntype", void 0)
], OutletDetailsController.prototype, "status", null);
__decorate([
    (0, common_1.Put)('time-increase/:id'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard, permissions_guard_1.PermissionsGuard),
    (0, roles_decorator_1.Roles)(...Object.values(enum_1.UserRole)),
    (0, permissions_decorator_1.CheckPermissions)([enum_1.PermissionAction.UPDATE, 'outlet_detail']),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, outlet_detail_dto_1.TimeIncreaseDto]),
    __metadata("design:returntype", void 0)
], OutletDetailsController.prototype, "timeIncrease", null);
OutletDetailsController = __decorate([
    (0, common_1.Controller)('outlet-details'),
    __metadata("design:paramtypes", [outlet_details_service_1.OutletDetailsService])
], OutletDetailsController);
exports.OutletDetailsController = OutletDetailsController;
//# sourceMappingURL=outlet-details.controller.js.map