"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RouteAssginLogService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const route_assgin_log_entity_1 = require("./entities/route-assgin-log.entity");
let RouteAssginLogService = class RouteAssginLogService {
    constructor(repo) {
        this.repo = repo;
    }
    async findAll(dto) {
        const fromDate = new Date(dto.fromDate);
        fromDate.setHours(0, 0, 0, 0);
        const toDate = new Date(dto.toDate);
        toDate.setHours(23, 59, 59, 59);
        const query = this.repo
            .createQueryBuilder('RouteAssginLog')
            .leftJoinAndSelect('RouteAssginLog.outletDetail', 'outletDetail')
            .select([
            'outletDetail.id',
            'outletDetail.storeName',
            'RouteAssginLog.id',
            'RouteAssginLog.fromRoute',
            'RouteAssginLog.toRoute',
            'RouteAssginLog.createdAt',
        ]);
        query.where('RouteAssginLog.createdAt >= :fromDate and RouteAssginLog.createdAt <= :toDate', { fromDate: fromDate, toDate: toDate });
        const [result, total] = await query
            .orderBy({ 'RouteAssginLog.createdAt': 'DESC' })
            .take(dto.limit)
            .skip(dto.offset)
            .getManyAndCount();
        return { result, total };
    }
    async findOne(id) {
        const result = await this.repo.findOne({ where: { id } });
        if (!result) {
            throw new common_1.NotFoundException('Log not found!');
        }
        return result;
    }
};
RouteAssginLogService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(route_assgin_log_entity_1.RouteAssginLog)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], RouteAssginLogService);
exports.RouteAssginLogService = RouteAssginLogService;
//# sourceMappingURL=route-assgin-log.service.js.map