"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RouteMasterService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const route_master_entity_1 = require("./entities/route-master.entity");
let RouteMasterService = class RouteMasterService {
    constructor(repo) {
        this.repo = repo;
    }
    async create(dto) {
        const route = await this.repo.findOne({ where: { routeName: dto.routeName } });
        if (route) {
            throw new common_1.ConflictException('Route already exists!');
        }
        const obj = Object.create(dto);
        return this.repo.save(obj);
    }
    async findAll(limit, offset, keyword, status) {
        const [result, total] = await this.repo
            .createQueryBuilder('RouteMaster')
            .leftJoinAndSelect('RouteMaster.account', 'account')
            .leftJoinAndSelect('account.staffDetail', 'staffDetail')
            .where('RouteMaster.status = :status', { status: status })
            .andWhere(new typeorm_2.Brackets((qb) => {
            qb.where('RouteMaster.routeName LIKE :routeName', {
                routeName: '%' + keyword + '%',
            });
        }))
            .take(limit)
            .skip(offset)
            .getManyAndCount();
        return { result, total };
    }
    async update(id, dto) {
        const result = await this.repo.findOne({ where: { id } });
        if (!result) {
            throw new common_1.NotFoundException('Route Master not found!');
        }
        const obj = Object.assign(result, dto);
        return this.repo.save(obj);
    }
    async updateDeliveryBoy(id, dto) {
        const result = await this.repo.findOne({ where: { id } });
        if (!result) {
            throw new common_1.NotFoundException('Route Master not found!');
        }
        const obj = Object.assign(result, dto);
        return this.repo.save(obj);
    }
    async status(id, dto) {
        const result = await this.repo.findOne({ where: { id } });
        if (!result) {
            throw new common_1.NotFoundException('Route Master not found!');
        }
        const obj = Object.assign(result, dto);
        return this.repo.save(obj);
    }
    async remove(id) {
        const result = await this.repo.findOne({ where: { id } });
        if (!result) {
            throw new common_1.NotFoundException('Not found!');
        }
        return this.repo.remove(result);
    }
};
RouteMasterService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(route_master_entity_1.RouteMaster)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], RouteMasterService);
exports.RouteMasterService = RouteMasterService;
//# sourceMappingURL=route-master.service.js.map