"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubCategoryController = void 0;
const common_1 = require("@nestjs/common");
const passport_1 = require("@nestjs/passport");
const platform_express_1 = require("@nestjs/platform-express");
const account_entity_1 = require("../account/entities/account.entity");
const current_user_decorator_1 = require("../auth/decorators/current-user.decorator");
const permissions_decorator_1 = require("../auth/decorators/permissions.decorator");
const roles_decorator_1 = require("../auth/decorators/roles.decorator");
const permissions_guard_1 = require("../auth/guards/permissions.guard");
const roles_guard_1 = require("../auth/guards/roles.guard");
const bool_status_dto_1 = require("../common/dto/bool-status.dto");
const pagination_dto_1 = require("../common/dto/pagination.dto");
const enum_1 = require("../enum");
const sub_category_dto_1 = require("./dto/sub-category.dto");
const sub_category_service_1 = require("./sub-category.service");
let SubCategoryController = class SubCategoryController {
    constructor(subCategoryService) {
        this.subCategoryService = subCategoryService;
    }
    create(dto) {
        return this.subCategoryService.create(dto);
    }
    findAll(query, categoryId) {
        const keyword = query.keyword || '';
        return this.subCategoryService.findAll(query.limit, query.offset, keyword, query.status, categoryId);
    }
    find(query, categoryId) {
        const keyword = query.keyword || '';
        return this.subCategoryService.find(query.limit, query.offset, keyword, categoryId);
    }
    findsubcate(categoryId) {
        return this.subCategoryService.findsubcate(categoryId);
    }
    findByMultiCat(query) {
        const keyword = query.keyword || '';
        return this.subCategoryService.findSub(query.limit, query.offset, keyword);
    }
    products(query, user) {
        const keyword = query.keyword || '';
        return this.subCategoryService.products(query.limit, query.offset, keyword, query.status, query.cartId, user.outletDetail[0].id, query.outletBranchId);
    }
    findOne(id) {
        return this.subCategoryService.findOne(id);
    }
    update(id, dto) {
        return this.subCategoryService.update(id, dto);
    }
    status(id, dto) {
        return this.subCategoryService.status(id, dto);
    }
    async image2(id, file) {
        return this.subCategoryService.image(id, file.path);
    }
};
__decorate([
    (0, common_1.Post)(),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard, permissions_guard_1.PermissionsGuard),
    (0, roles_decorator_1.Roles)(enum_1.UserRole.ADMIN, enum_1.UserRole.SUPER_ADMIN, enum_1.UserRole.STAFF),
    (0, permissions_decorator_1.CheckPermissions)([enum_1.PermissionAction.CREATE, 'sub_category']),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [sub_category_dto_1.SubCategoryDto]),
    __metadata("design:returntype", void 0)
], SubCategoryController.prototype, "create", null);
__decorate([
    (0, common_1.Get)('list/all/:categoryId'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard, permissions_guard_1.PermissionsGuard),
    (0, roles_decorator_1.Roles)(enum_1.UserRole.ADMIN, enum_1.UserRole.SUPER_ADMIN, enum_1.UserRole.STAFF),
    (0, permissions_decorator_1.CheckPermissions)([enum_1.PermissionAction.READ, 'sub_category']),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, common_1.Param)('categoryId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [sub_category_dto_1.PaginationSDto, String]),
    __metadata("design:returntype", void 0)
], SubCategoryController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)('list/:categoryId'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, common_1.Param)('categoryId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [pagination_dto_1.PaginationDto, String]),
    __metadata("design:returntype", void 0)
], SubCategoryController.prototype, "find", null);
__decorate([
    (0, common_1.Get)('allsub/:categoryId'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    __param(0, (0, common_1.Param)('categoryId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SubCategoryController.prototype, "findsubcate", null);
__decorate([
    (0, common_1.Get)('list'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [sub_category_dto_1.PaginationPDto]),
    __metadata("design:returntype", void 0)
], SubCategoryController.prototype, "findByMultiCat", null);
__decorate([
    (0, common_1.Get)(),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [sub_category_dto_1.ProductPaginationDto, account_entity_1.Account]),
    __metadata("design:returntype", void 0)
], SubCategoryController.prototype, "products", null);
__decorate([
    (0, common_1.Get)(':id'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], SubCategoryController.prototype, "findOne", null);
__decorate([
    (0, common_1.Patch)(':id'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard, permissions_guard_1.PermissionsGuard),
    (0, roles_decorator_1.Roles)(enum_1.UserRole.ADMIN, enum_1.UserRole.SUPER_ADMIN, enum_1.UserRole.STAFF),
    (0, permissions_decorator_1.CheckPermissions)([enum_1.PermissionAction.UPDATE, 'sub_category']),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, sub_category_dto_1.SubCategoryDto]),
    __metadata("design:returntype", void 0)
], SubCategoryController.prototype, "update", null);
__decorate([
    (0, common_1.Put)('status/:id'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard, permissions_guard_1.PermissionsGuard),
    (0, roles_decorator_1.Roles)(enum_1.UserRole.ADMIN, enum_1.UserRole.SUPER_ADMIN, enum_1.UserRole.STAFF),
    (0, permissions_decorator_1.CheckPermissions)([enum_1.PermissionAction.UPDATE, 'sub_category']),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, bool_status_dto_1.BoolStatusDto]),
    __metadata("design:returntype", void 0)
], SubCategoryController.prototype, "status", null);
__decorate([
    (0, common_1.Put)(':id'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, roles_decorator_1.Roles)(enum_1.UserRole.ADMIN, enum_1.UserRole.SUPER_ADMIN, enum_1.UserRole.STAFF),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)('file')),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.UploadedFile)(new common_1.ParseFilePipe({
        validators: [
            new common_1.FileTypeValidator({ fileType: '.(png|jpeg|jpg)' }),
            new common_1.MaxFileSizeValidator({ maxSize: 1024 * 1024 * 1 }),
        ],
    }))),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], SubCategoryController.prototype, "image2", null);
SubCategoryController = __decorate([
    (0, common_1.Controller)('sub-category'),
    __metadata("design:paramtypes", [sub_category_service_1.SubCategoryService])
], SubCategoryController);
exports.SubCategoryController = SubCategoryController;
//# sourceMappingURL=sub-category.controller.js.map