"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendBulkNotifications = exports.sendNotifications = void 0;
const axios_1 = require("axios");
async function sendNotifications(fcm, title, msg) {
    try {
        const payload = await axios_1.default.post('https://fcm.googleapis.com/fcm/send', {
            to: fcm,
            data: {
                body: msg,
                title: title,
                sound: 'default',
                type: 1,
                priority: "high"
            },
            notification: {
                body: msg,
                title: title,
                sound: 'default',
                type: 1,
                priority: "high"
            },
        }, {
            headers: {
                'Content-Type': 'application/json',
                'Authorization': 'key=' + process.env.NOTIFY_AUTH,
            },
        });
        return payload.data;
    }
    catch (error) {
        return { Stauts: 'Error', Details: null };
    }
}
exports.sendNotifications = sendNotifications;
async function sendBulkNotifications(title, msg) {
    try {
        const payload = await axios_1.default.post('https://fcm.googleapis.com/fcm/send', {
            to: '/topics/all',
            data: {
                body: msg,
                title: title,
                sound: 'default',
                type: 1,
            },
            notification: {
                body: msg,
                title: title,
                sound: 'default',
                type: 1,
            },
        }, {
            headers: {
                'cache-control': 'no-cache',
                'Content-Type': 'application/json',
                Authorization: 'key=' + process.env.NOTIFY_AUTH,
            },
        });
        return payload.data;
    }
    catch (error) {
        return { Stauts: 'Error', Details: null };
    }
}
exports.sendBulkNotifications = sendBulkNotifications;
//# sourceMappingURL=notify.utils.js.map