import {
  Body,
  Controller,
  Get,
  Ip,
  Post,
  Req,
  UseGuards,
  Query,
} from '@nestjs/common';
import { AuthGuard } from '@nestjs/passport';
import { Account } from 'src/account/entities/account.entity';
import { AuthService } from './auth.service';
import { CurrentUser } from './decorators/current-user.decorator';

import { MobLoginDto, SigninDto, PassDto } from './dto/login.dto';

@Controller('auth')
export class AuthController {
  constructor(private readonly authService: AuthService) {}

  @Post('admin/login')
  signin(@Body() dto: SigninDto, @Ip() ip) {
    return this.authService.signIn(dto.loginId, dto.password, ip);
  }

  @Post('mobile/login')
  mobileLogin(@Body() dto: MobLoginDto, @Ip() ip) {
    return this.authService.mobLogin(dto, ip);
  }

  @Get()
  async verifyOtp() {
    const distance = await this.authService.calculateDistance(
      52.52,
      13.405,
      48.8566,
      2.3522,
    );
    return distance;
  }

  @Get('chaeck-pass')
  @UseGuards(AuthGuard('jwt'))
  find(@Query() query: PassDto, @CurrentUser() user: Account) {
    return this.authService.find(query, user.password);
  }

  @Get('logout')
  @UseGuards(AuthGuard('jwt'))
  logout(@CurrentUser() user: Account, @Req() req, @Ip() ip) {
    return this.authService.logout(user.id, req.headers.origin, ip);
  }
}
// res.setHeader('Cache-Control', `public, max-age=3600, version=${this.dataVersion}`);
