import { ApiProperty } from '@nestjs/swagger';
import { Type } from 'class-transformer';
import {
  IsArray,
  IsEmail,
  IsEnum,
  IsNotEmpty,
  IsNumber,
  IsOptional,
  IsString,
  Max,
  MaxLength,
  Min,
  MinLength,
} from 'class-validator';
// import { CompanyCategoryDto } from 'src/company-category/dto/company-category.dto';
// import { CompanySubCategoryDto } from 'src/company-sub-category/dto/company-sub-category.dto';
import { CompanyStatus } from 'src/enum';

export class BusinessDetailDto {
  @IsNotEmpty()
  @ApiProperty()
  @IsString()
  @MinLength(1)
  @MaxLength(20)
  contactNo: string;

  @ApiProperty()
  @IsOptional()
  @MinLength(0)
  @MaxLength(20)
  altContactNo: string;

  @IsNotEmpty()
  @ApiProperty()
  @IsString()
  @MinLength(1)
  @MaxLength(50)
  personName: string;

  @IsNotEmpty()
  @ApiProperty()
  @IsString()
  @MinLength(2)
  @MaxLength(50)
  businessName: string;

  @IsNotEmpty()
  @ApiProperty()
  @IsString()
  @MinLength(2)
  @MaxLength(50)
  legalName: string;

  @IsNotEmpty()
  @ApiProperty()
  @IsString()
  @MinLength(2)
  @MaxLength(50)
  businessNature: string;

  @IsNotEmpty()
  @ApiProperty()
  @IsEmail()
  email: string;

  @IsNotEmpty()
  @ApiProperty()
  @MinLength(6)
  @MaxLength(500)
  address: string;

  @IsNotEmpty()
  @ApiProperty()
  @IsNumber()
  @Min(0)
  stateId: number;

  @IsNotEmpty()
  @ApiProperty()
  @IsNumber()
  @Min(0)
  cityId: number;

  @ApiProperty()
  @IsOptional()
  desc: string;

  @IsOptional()
  accountId: string;
}

export class CompanyDetailDto {
  @IsNotEmpty()
  @ApiProperty()
  @IsString()
  @MinLength(1)
  @MaxLength(20)
  contactNo: string;

  @ApiProperty()
  @IsOptional()
  @MinLength(0)
  @MaxLength(20)
  altContactNo: string;

  @IsNotEmpty()
  @ApiProperty()
  @IsString()
  @MinLength(1)
  @MaxLength(50)
  personName: string;

  @IsNotEmpty()
  @ApiProperty()
  @IsString()
  @MinLength(2)
  @MaxLength(50)
  businessName: string;

  @IsNotEmpty()
  @ApiProperty()
  @IsString()
  @MinLength(2)
  @MaxLength(50)
  legalName: string;

  @IsNotEmpty()
  @ApiProperty()
  @IsString()
  @MinLength(2)
  @MaxLength(50)
  businessNature: string;

  @IsNotEmpty()
  @ApiProperty()
  @IsEmail()
  email: string;

  @IsNotEmpty()
  @ApiProperty()
  @MinLength(6)
  @MaxLength(500)
  address: string;

  @IsNotEmpty()
  @ApiProperty()
  @IsNumber()
  @Min(0)
  stateId: number;

  @IsNotEmpty()
  @ApiProperty()
  @IsNumber()
  @Min(0)
  cityId: number;

  @ApiProperty()
  @IsOptional()
  desc: string;

  @IsOptional()
  accountId: string;
}

export class StatusDto {
  @IsNotEmpty()
  @ApiProperty()
  @IsEnum(CompanyStatus)
  status: CompanyStatus;
}

export class PaginationSDto {
  @ApiProperty()
  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(10)
  @Max(50)
  limit: number;

  @ApiProperty()
  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(0)
  offset: number;

  @ApiProperty()
  @IsOptional()
  keyword: string;

  @ApiProperty()
  @IsNotEmpty()
  @IsEnum(CompanyStatus)
  status: CompanyStatus;
}

export class PaginationDto {
  @ApiProperty()
  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(10)
  @Max(50)
  limit: number;

  @ApiProperty()
  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(0)
  offset: number;

  @ApiProperty()
  @IsOptional()
  keyword: string;

  @ApiProperty()
  @IsOptional()
  @IsArray()
  category: any; // [1,2,3,4,5]

  @ApiProperty()
  @IsOptional()
  @IsArray()
  subCategory: any; // [1,2,3,4,5]
}
