import { ValidationPipe } from '@nestjs/common';
import { NestFactory } from '@nestjs/core';
import { DocumentBuilder, SwaggerModule } from '@nestjs/swagger';
import { AppModule } from './app.module';

import { readFileSync } from 'fs';

async function bootstrap() {
    const httpsOptions = {
      key: readFileSync('ssl/private.pem'),
      cert: readFileSync('ssl/certificate.crt'),
      ca: readFileSync('ssl/sslca.ca-bundle'),
    };
  const app = await NestFactory.create(AppModule, { httpsOptions });
  app.setGlobalPrefix('api/v1');
  app.useGlobalPipes(new ValidationPipe({ transform: true }));
  app.enableCors();

  const config = new DocumentBuilder()
    .setTitle('Ambuja Server')
    .setDescription('The Ambuja server API description')
    .setVersion('1.0')
    .addTag('Ambuja Server')
    .addBearerAuth()
    .build();

  const document = SwaggerModule.createDocument(app, config);
  SwaggerModule.setup('api', app, document);
  await app.listen(8000);
}
bootstrap();
