import { Account } from 'src/account/entities/account.entity';
import { Faq } from 'src/faqs/entities/faq.entity';
import { Feedback } from 'src/feedback/entities/feedback.entity';
import {
  Column,
  CreateDateColumn,
  Entity,
  OneToMany,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';
import { DefaultStatus } from '../../enum';

@Entity()
export class Setting {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'varchar', length: 50, nullable: true })
  title: string;

  @Column({ type: 'text', nullable: true })
  logo: string;

  @Column({ type: 'text', nullable: true })
  logoName: string;

  @Column({ type: 'varchar', length: 50, nullable: true })
  version: string;

  @Column({ type: 'boolean', default: false })
  maintenance: boolean;

  @Column({ type: 'varchar', length: 50, nullable: true })
  contactEmail: string;

  @Column({ type: 'varchar', length: 50, nullable: true })
  contactAltEmail: string;

  @Column({ type: 'varchar', length: 50, nullable: true })
  contactPhone: string;

  @Column({ type: 'varchar', length: 50, nullable: true })
  contactAltPhone: string;

  @Column({ type: 'varchar', length: 50, nullable: true })
  contactAddress: string;

  @Column({ type: 'varchar', length: 50, nullable: true })
  contactPerson: string;

  @Column({ type: 'varchar', length: 50, nullable: true })
  contactAltPerson: string;

  @Column({ type: 'enum', enum: DefaultStatus, default: DefaultStatus.PENDING })
  status: DefaultStatus;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @OneToMany(() => Account, (account) => account.setting)
  account: Account[];

  @OneToMany(() => Feedback, (charge) => charge.setting)
  feedback: Feedback[];

  @OneToMany(() => Faq, (faq) => faq.setting)
  faq: Faq[];
}
