import { CompanyDetail } from 'src/company-details/entities/company-detail.entity';
import { ContactUs } from 'src/contact-us/entities/contact-us.entity';
import { AIType, DefaultStatus, UserRole } from 'src/enum';
import { Faq } from 'src/faqs/entities/faq.entity';
import { Feedback } from 'src/feedback/entities/feedback.entity';
import { LoginHistory } from 'src/login-history/entities/login-history.entity';
import { Notification } from 'src/notifications/entities/notification.entity';
import { Order } from 'src/orders/entities/order.entity';
import { OutletDetail } from 'src/outlet-details/entities/outlet-detail.entity';
import { Setting } from 'src/settings/entities/setting.entity';
import { StaffDetail } from 'src/staff-details/entities/staff-detail.entity';
import { Ticket } from 'src/tickets/entities/ticket.entity';
import { UserPermission } from 'src/user-permissions/entities/user-permission.entity';
import { RouteMaster } from 'src/route-master/entities/route-master.entity';
import {
  Column,
  CreateDateColumn,
  Entity,
  ManyToOne,
  OneToMany,
  OneToOne,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';

@Entity()
export class Account {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'varchar', length: 20, unique: true })
  loginId: string;

  @Column({ type: 'varchar', length: 20, nullable: true })
  employeeId: string;

  @Column({ type: 'text', nullable: true })
  password: string;

  @Column({ type: 'text', nullable: true })
  passwordShow: string;

  @Column({ type: 'text', nullable: true })
  deviceId: string;

  @Column({ type: 'text', nullable: true })
  fcm: string;

  @Column({ type: 'int', default: 0 })
  wrongCount: number;

  @Column({ type: 'datetime', nullable: true })
  activeAt: Date;

  @Column({ type: 'enum', enum: AIType, default: AIType.INACTIVE })
  lastStatus: AIType;

  @Column({ type: 'uuid', nullable: true })
  createdBy: string;

  @Column({ type: 'enum', enum: UserRole, default: UserRole.SUB_OUTLET })
  roles: UserRole;

  @Column({ type: 'enum', enum: DefaultStatus, default: DefaultStatus.ACTIVE })
  status: DefaultStatus;

  @Column({ type: 'uuid', nullable: true })
  settingId: string;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @ManyToOne(() => Setting, (setting) => setting.account, {
    cascade: true,
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  setting: Setting[];

  @OneToMany(() => StaffDetail, (staffDetail) => staffDetail.account)
  staffDetail: StaffDetail[];

  @OneToMany(() => OutletDetail, (outletDetail) => outletDetail.account)
  outletDetail: OutletDetail[];

  @OneToMany(() => Notification, (notification) => notification.account)
  notification: Notification[];

  @OneToMany(() => LoginHistory, (loginHistory) => loginHistory.account)
  loginHistory: LoginHistory[];

  @OneToMany(() => UserPermission, (userPermission) => userPermission.account)
  userPermission: UserPermission[];

  @OneToMany(() => CompanyDetail, (companyDetail) => companyDetail.account)
  companyDetail: CompanyDetail[];

  @OneToMany(() => Feedback, (feedback) => feedback.account)
  feedback: Feedback[];

  @OneToMany(() => Faq, (faq) => faq.account)
  faq: Faq[];

  @OneToMany(() => Ticket, (ticket) => ticket.account)
  ticket: Ticket[];

  @OneToMany(() => ContactUs, (contactUs) => contactUs.account)
  contactUs: ContactUs[];

  @OneToMany(() => Order, (order) => order.account)
  order: Order[];

  @OneToMany(() => RouteMaster, (routeMaster) => routeMaster.account)
  routeMaster: RouteMaster[];
}
