import { CacheModule } from '@nestjs/cache-manager';
import { Module } from '@nestjs/common';
import { ConfigModule } from '@nestjs/config';
import { ThrottlerModule } from '@nestjs/throttler';
import { TypeOrmModule } from '@nestjs/typeorm';
import { AccountModule } from './account/account.module';
import { AppController } from './app.controller';
import { AppService } from './app.service';
import { AreaModule } from './area/area.module';
import { AuthModule } from './auth/auth.module';
import { CategoryModule } from './category/category.module';
import { CityModule } from './city/city.module';
import { CompanyCategoryModule } from './company-category/company-category.module';
import { CompanyDetailsModule } from './company-details/company-details.module';
import { CompanySubCategoryModule } from './company-sub-category/company-sub-category.module';
import { ContactUsModule } from './contact-us/contact-us.module';
import { DashboardModule } from './dashboard/dashboard.module';
import { FaqsModule } from './faqs/faqs.module';
import { FeedbackModule } from './feedback/feedback.module';
import { LoginHistoryModule } from './login-history/login-history.module';
import { MenusModule } from './menus/menus.module';
import { NotificationsModule } from './notifications/notifications.module';
import { NotifyModule } from './notify/notify.module';
import { OrdersModule } from './orders/orders.module';
import { OutletBranchModule } from './outlet-branch/outlet-branch.module';
import { OutletDetailsModule } from './outlet-details/outlet-details.module';
import { PermissionsModule } from './permissions/permissions.module';
import { SettingsModule } from './settings/settings.module';
import { StaffDetailsModule } from './staff-details/staff-details.module';
import { StateModule } from './state/state.module';
import { SubCategoryModule } from './sub-category/sub-category.module';
import { TicketsModule } from './tickets/tickets.module';
import { UserPermissionsModule } from './user-permissions/user-permissions.module';
import { OutletCategoryModule } from './outlet-category/outlet-category.module';
import { OutletSubCategoryModule } from './outlet-sub-category/outlet-sub-category.module';
import { RouteMasterModule } from './route-master/route-master.module';
import { RouteAssginLogModule } from './route-assgin-log/route-assgin-log.module';


@Module({
  imports: [
    ConfigModule.forRoot(),
    ThrottlerModule.forRoot([
      {
        name: 'short',
        ttl: 1000,
        limit: 3,
      },
      {
        name: 'medium',
        ttl: 10000,
        limit: 20,
      },
      {
        name: 'long',
        ttl: 60000,
        limit: 100,
      },
    ]),

    // aws db connection
    TypeOrmModule.forRoot({
      type: 'mysql',
      host: process.env.SM_DB_HOST,
      port: Number(process.env.SM_DB_PORT),
      username: process.env.SM_USER_NAME,
      password: process.env.SM_DB_PASS,
      database: process.env.SM_DB_NAME,
      entities: [__dirname + '/**/*.entity{.ts,.js}'],
      synchronize: false,
      logging: false,
    }),
    CacheModule.register({
      isGlobal: true,
    }),
    AccountModule,
    AuthModule,
    LoginHistoryModule,
    StaffDetailsModule,
    MenusModule,
    PermissionsModule,
    UserPermissionsModule,
    CategoryModule,
    SubCategoryModule,
    OutletDetailsModule,
    OutletBranchModule,
    StateModule,
    AreaModule,
    CityModule,
    NotificationsModule,
    OrdersModule,
    TicketsModule,
    ContactUsModule,
    SettingsModule,
    FeedbackModule,
    FaqsModule,
    CompanyDetailsModule,
    CompanyCategoryModule,
    CompanySubCategoryModule,
    DashboardModule,
    NotifyModule,
    OutletCategoryModule,
    OutletSubCategoryModule,
    RouteMasterModule,
    RouteAssginLogModule,
  ],
  controllers: [AppController],
  providers: [AppService],
})
export class AppModule {}
