import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { AuthModule } from 'src/auth/auth.module';
import { CompanyCategoryController } from './company-category.controller';
import { CompanyCategoryService } from './company-category.service';
import { CompanyCategory } from './entities/company-category.entity';

@Module({
  imports: [TypeOrmModule.forFeature([CompanyCategory]), AuthModule],
  controllers: [CompanyCategoryController],
  providers: [CompanyCategoryService],
  exports: [CompanyCategoryService],
})
export class CompanyCategoryModule {}
