import {
  ConflictException,
  Injectable,
  NotFoundException,
} from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import { CompanyCategoryDto, BoolStatusDto } from './dto/company-category.dto';
import { CompanyCategory } from './entities/company-category.entity';

@Injectable()
export class CompanyCategoryService {
  constructor(
    @InjectRepository(CompanyCategory)
    private readonly repo: Repository<CompanyCategory>,
  ) {}

  async create(dto: CompanyCategoryDto) {
    const result = await this.repo.findOne({
      where: {
        companyDetailId: dto.companyDetailId,
        categoryId: dto.categoryId,
      },
    });
    if (result) {
      throw new ConflictException('Already exists!');
    }
    const obj = Object.create(dto);
    return this.repo.save(obj);
  }

  async status(id: string, dto: BoolStatusDto) {
    const result = await this.repo.findOne({ where: { id } });
    if (!result) {
      throw new NotFoundException('Not found!');
    }
    const obj = Object.assign(result, dto);
    return this.repo.save(obj);
  }

  async remove(id: string) {
    const result = await this.repo.findOne({ where: { id } });
    if (!result) {
      throw new NotFoundException('Not found!');
    }
    return this.repo.remove(result);
  }
}
