import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { AuthModule } from 'src/auth/auth.module';
import { CompanyCategoryModule } from 'src/company-category/company-category.module';
import { CompanySubCategoryModule } from 'src/company-sub-category/company-sub-category.module';
import { CompanyDetailsController } from './company-details.controller';
import { CompanyDetailsService } from './company-details.service';
import { CompanyDetail } from './entities/company-detail.entity';
import { MulterModule } from '@nestjs/platform-express';

@Module({
  imports: [
    TypeOrmModule.forFeature([CompanyDetail]),
    AuthModule,
    CompanySubCategoryModule,
    CompanyCategoryModule,
    MulterModule.register({ dest: './uploads/company/files' }),
  ],
  controllers: [CompanyDetailsController],
  providers: [CompanyDetailsService],
})
export class CompanyDetailsModule {}
