import { Account } from 'src/account/entities/account.entity';
import { CompanyCategory } from 'src/company-category/entities/company-category.entity';
import { CompanySubCategory } from 'src/company-sub-category/entities/company-sub-category.entity';
import { CompanyStatus } from 'src/enum';
import { OutletBranch } from 'src/outlet-branch/entities/outlet-branch.entity';
import { State } from 'src/state/entities/state.entity';
import { City } from 'src/city/entities/city.entity';
import {
  Column,
  CreateDateColumn,
  Entity,
  JoinTable,
  ManyToOne,
  OneToMany,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';

@Entity()
export class CompanyDetail {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'varchar', length: 50, nullable: true })
  businessName: string;

  @Column({ type: 'varchar', length: 50, nullable: true })
  personName: string;

  @Column({ type: 'varchar', length: 50, nullable: true })
  legalName: string;

  @Column({ type: 'varchar', length: 50, nullable: true })
  businessNature: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  email: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  desc: string;

  @Column({ type: 'text', nullable: true })
  logo: string;

  @Column({ type: 'text', nullable: true })
  logoName: string;

  @Column({ type: 'text', nullable: true })
  file: string;

  @Column({ type: 'text', nullable: true })
  fileName: string;

  @Column({ type: 'text', nullable: true })
  address: string;

  @Column({ type: 'varchar', length: 20, nullable: true })
  contactNo: string;

  @Column({ type: 'varchar', length: 20, nullable: true })
  altContactNo: string;

  @Column({ type: 'enum', enum: CompanyStatus, default: CompanyStatus.PENDING })
  status: CompanyStatus;

  // created by
  @Column({ type: 'uuid' })
  accountId: string;

  @Column({ type: 'int' })
  stateId: number;

  @Column({ type: 'int' })
  cityId: number;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @OneToMany(
    () => CompanyCategory,
    (companyCategory) => companyCategory.companyDetail,
  )
  companyCategory: CompanyCategory;

  @OneToMany(
    () => CompanySubCategory,
    (companySubCategory) => companySubCategory.companyDetail,
  )
  companySubCategory: CompanySubCategory;

  @OneToMany(() => OutletBranch, (outletBranch) => outletBranch.companyDetail)
  outletBranch: OutletBranch;

  @ManyToOne(() => Account, (account) => account.companyDetail, {
    cascade: true,
    onUpdate: 'CASCADE',
    onDelete: 'CASCADE',
  })
  account: Account[];

  @ManyToOne(() => State, (state) => state.companyDetail, {
    cascade: true,
    onUpdate: 'CASCADE',
    onDelete: 'CASCADE',
  })
  state: State[];

  @ManyToOne(() => City, (city) => city.companyDetail, {
    cascade: true,
    onUpdate: 'CASCADE',
    onDelete: 'CASCADE',
  })
  city: City[];
}
