import {
  Body,
  Controller,
  Delete,
  Param,
  Post,
  Put,
  UseGuards,
} from '@nestjs/common';
import { AuthGuard } from '@nestjs/passport';
import { ApiOperation } from '@nestjs/swagger';
import { Roles } from 'src/auth/decorators/roles.decorator';
import { RolesGuard } from 'src/auth/guards/roles.guard';
import { UserRole } from 'src/enum';
import { CompanySubCategoryService } from './company-sub-category.service';
import { CompanySubCategoryDto, BoolStatusDto } from './dto/company-sub-category.dto';

@Controller('company-sub-category')
export class CompanySubCategoryController {
  constructor(
    private readonly companySubCategoryService: CompanySubCategoryService,
  ) {}

  @Post(':id')
  @ApiOperation({ summary: 'For Vendor' })
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN, UserRole.STAFF, UserRole.SUPER_ADMIN)
  create(@Param('id') id: string, @Body() dto: CompanySubCategoryDto) {
    dto.companyDetailId = id;
    return this.companySubCategoryService.create(dto);
  }

  @Put(':id')
  @ApiOperation({ summary: 'For Admin' })
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN, UserRole.SUPER_ADMIN, UserRole.STAFF)
  status(@Param('id') id: string, @Body() dto: BoolStatusDto) {
    return this.companySubCategoryService.status(id, dto);
  }

  @Delete(':id')
  @ApiOperation({ summary: 'For Vendor' })
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN, UserRole.STAFF, UserRole.SUPER_ADMIN)
  remove(@Param('id') id: string) {
    return this.companySubCategoryService.remove(id);
  }
}
