import { ApiProperty } from '@nestjs/swagger';
import { Type } from 'class-transformer';
import { IsNotEmpty, IsOptional, IsUUID, IsBoolean } from 'class-validator';

export class CompanySubCategoryDto {
  @ApiProperty()
  @IsNotEmpty()
  subCategoryId: string;

  @IsOptional()
  @IsUUID()
  companyDetailId: string;
}

export class BoolStatusDto {
  @ApiProperty()
  @IsNotEmpty()
  @Type(() => Boolean)
  @IsBoolean()
  status: boolean;
}