import { Injectable } from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';

import { Account } from 'src/account/entities/account.entity';
import { Order } from 'src/orders/entities/order.entity';
import { OutletDetail } from 'src/outlet-details/entities/outlet-detail.entity';
import { OrderStatus } from 'src/enum';

@Injectable()
export class DashboardService {
  constructor(
    @InjectRepository(Account)
    private readonly aRepo: Repository<Account>,
    @InjectRepository(Order)
    private readonly oRepo: Repository<Order>,
    @InjectRepository(OutletDetail)
    private readonly odRepo: Repository<OutletDetail>,
  ) {}

  async suboutletCounts() {
    const query = this.aRepo
      .createQueryBuilder('account')
      .select(['COUNT(account.id) AS count'])
      .addSelect(['account.roles as name'])
      .where(
        'account.roles = :roles',
        {
          roles: 'SUB OUTLET',
        },
      );
    
    return await query.getRawMany();
  }

  async deliveryboyCounts() {
    const query = this.aRepo
      .createQueryBuilder('account')
      .select(['COUNT(account.id) AS count'])
      .addSelect(['account.roles as name'])
      .where(
        'account.roles = :roles',
        {
          roles: 'Delivery Boy',
        },
      );
    
    return await query.getRawMany();
  }

  async adminCounts() {
    const query = this.aRepo
      .createQueryBuilder('account')
      .select(['COUNT(account.id) AS count'])
      .addSelect(['account.roles as name'])
      .where(
        'account.roles = :roles',
        {
          roles: 'ADMIN',
        },
      );
    
    return await query.getRawMany();
  }

  async superadminCounts() {
    const query = this.aRepo
      .createQueryBuilder('account')
      .select(['COUNT(account.id) AS count'])
      .addSelect(['account.roles as name'])
      .where(
        'account.roles = :roles',
        {
          roles: 'SUPER ADMIN',
        },
      );
    
    return await query.getRawMany();
  }

  async staffCounts() {
    const query = this.aRepo
      .createQueryBuilder('account')
      .select(['COUNT(account.id) AS count'])
      .addSelect(['account.roles as name'])
      .where(
        'account.roles = :roles',
        {
          roles: 'STAFF',
        },
      );
    
    return await query.getRawMany();
  }

  async basekitchenCounts() {
    const query = this.aRepo
      .createQueryBuilder('account')
      .select(['COUNT(account.id) AS count'])
      .addSelect(['account.roles as name'])
      .where(
        'account.roles = :roles',
        {
          roles: 'BASE KITCHEN',
        },
      );
    
    return await query.getRawMany();
  }
  
  async cartCounts() {
    const query = this.oRepo
      .createQueryBuilder('Order')
      .select(['COUNT(Order.id) AS count'])
      .addSelect(['Order.status as name'])
      .where(
        'Order.status = :status',
        {
          status: 'CART',
        },
      );
      
    return await query.getRawMany();
  }

  async draftCounts() {
    const query = this.oRepo
      .createQueryBuilder('Order')
      .select(['COUNT(Order.id) AS count'])
      .addSelect(['Order.status as name'])
      .where(
        'Order.status = :status',
        {
          status: 'DRAFT',
        },
      );

    return await query.getRawMany();
  }

  async orderdCounts() {
   const query = this.oRepo
      .createQueryBuilder('Order')
      .select(['COUNT(Order.id) AS count'])
      .addSelect(['Order.status as name'])
      .where(
        'Order.status = :status',
        {
          status: 'ORDERED',
        },
      );
    
    return await query.getRawMany();
  }

  async dispatchedCounts() {
    const query = this.oRepo
      .createQueryBuilder('Order')
      .select(['COUNT(Order.id) AS count'])
      .addSelect(['Order.status as name'])
      .where(
        'Order.status = :status',
        {
          status: 'DISPATCHED',
        },
      );
    
    return await query.getRawMany();
  }

  async deliveredCounts() {
    const query = this.oRepo
      .createQueryBuilder('Order')
      .select(['COUNT(Order.id) AS count'])
      .addSelect(['Order.status as name'])
      .where(
        'Order.status = :status',
        {
          status: 'DELIVERED',
        },
      );
    
    return await query.getRawMany();
  }

  async returnedCounts() {
    const query = this.oRepo
      .createQueryBuilder('Order')
      .select(['COUNT(Order.id) AS count'])
      .addSelect(['Order.status as name'])
      .where(
        'Order.status = :status',
        {
          status: 'RETURNED',
        },
      );
    
    return await query.getRawMany();
  }

  async partialCounts() {
    const query = this.oRepo
      .createQueryBuilder('Order')
      .select(['COUNT(Order.id) AS count'])
      .addSelect(['Order.status as name'])
      .where(
        'Order.status = :status',
        {
          status: 'PARTIALLY DELIVERED',
        },
      );
    return await query.getRawMany();
  }

  async totalStaffsCounts() {
    const query = this.aRepo
      .createQueryBuilder('account')
      .select(['COUNT(account.id) AS count'])
      .where(
        'account.roles = :roles OR account.roles = :sroles',
        {
          roles: 'ADMIN',
          sroles: 'STAFF',
        },
      );
    return await query.getRawMany();
  }

  async totalOrdersCounts() {
    const query = this.oRepo
      .createQueryBuilder('Order')
      .select(['COUNT(Order.id) AS count'])
      .addSelect(['Order.status as name'])
      .where(
        'Order.status != :status OR Order.status != :cstatus',
        {
          status: 'CART',
          cstatus: 'DRAFT',
        },
      );
    return await query.getRawMany();
  }

  async totalOutletsCounts() {
    const query = this.odRepo
      .createQueryBuilder('outletDetail')
      .select(['COUNT(outletDetail.id) AS count']);
    
    return await query.getRawMany();
  }
  
}
