import {
  Body,
  Controller,
  Delete,
  Get,
  Param,
  Post,
  Put,
  UseGuards,
} from '@nestjs/common';
import { AuthGuard } from '@nestjs/passport';
import { ApiOperation } from '@nestjs/swagger';
import { Roles } from 'src/auth/decorators/roles.decorator';
import { RolesGuard } from 'src/auth/guards/roles.guard';
import { UserRole } from 'src/enum';
import { OutletSubCategoryDto, BoolStatusDto } from './dto/outlet-sub-category.dto';
import { OutletSubCategoryService } from './outlet-sub-category.service';

@Controller('outlet-sub-category')
export class OutletSubCategoryController {
  constructor(
    private readonly outletSubCategoryService: OutletSubCategoryService,
  ) {}

  @Post(':id')
  @ApiOperation({ summary: 'For Vendor' })
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN, UserRole.STAFF, UserRole.SUPER_ADMIN)
  create(@Param('id') id: string, @Body() dto: OutletSubCategoryDto) {
    dto.outletBranchId = id;
    return this.outletSubCategoryService.create(dto);
  }

  @Get(':id')
  @ApiOperation({ summary: 'For Vendor' })
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN, UserRole.SUPER_ADMIN, UserRole.STAFF)
  findAll(@Param('id') id: string) {
    return this.outletSubCategoryService.findAll(id);
  }

  @Put(':id')
  @ApiOperation({ summary: 'For Admin' })
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN, UserRole.SUPER_ADMIN, UserRole.STAFF)
  status(@Param('id') id: string, @Body() dto: BoolStatusDto) {
    return this.outletSubCategoryService.status(id, dto);
  }

  @Delete(':id')
  @ApiOperation({ summary: 'For Vendor' })
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN, UserRole.STAFF, UserRole.SUPER_ADMIN)
  remove(@Param('id') id: string) {
    return this.outletSubCategoryService.remove(id);
  }
}
