import {
  Controller,
  Get,
  Query,
  UseGuards,
} from '@nestjs/common';
import { AuthGuard } from '@nestjs/passport';
import { Roles } from 'src/auth/decorators/roles.decorator';
import { RolesGuard } from 'src/auth/guards/roles.guard';
import { UserRole } from 'src/enum';
import {
  PaginationAllDto
} from './dto/route-assgin-log.dto';
import { RouteAssginLogService } from './route-assgin-log.service';

@Controller('route-assgin-log')
export class RouteAssginLogController {
  constructor(private readonly routeAssginLogService: RouteAssginLogService) {}

  @Get('/list')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN, UserRole.SUPER_ADMIN, UserRole.STAFF)
  findAll(@Query() query: PaginationAllDto) {
    return this.routeAssginLogService.findAll(query);
  }
}
