import { Account } from 'src/account/entities/account.entity';
import { OutletDetail } from 'src/outlet-details/entities/outlet-detail.entity';
import { Column, Entity, OneToMany, PrimaryGeneratedColumn, ManyToOne } from 'typeorm';

@Entity()
export class RouteMaster {
  @PrimaryGeneratedColumn('increment')
  id: number;

  @Column({ type: 'varchar', length: 100 })
  routeName: string;

  @Column({ type: 'varchar', length: 100 })
  startPoint: string;

  @Column({ type: 'varchar', length: 100 })
  endPoint: string;

  @Column({ type: 'uuid', nullable: true })
  accountId: string;

  @Column({ type: 'boolean', default: false })
  status: boolean;

  @ManyToOne(() => Account, (account) => account.routeMaster, {
    cascade: true,
    onUpdate: 'CASCADE',
    onDelete: 'CASCADE',
  })
  account: Account[];

  @OneToMany(() => OutletDetail, (outletDetail) => outletDetail.routeMaster)
  outletDetail: OutletDetail[];


}
