import { ContactUs } from 'src/contact-us/entities/contact-us.entity';
import { AIType, DefaultStatus, LoginType, UserRole } from 'src/enum';
import { Feedback } from 'src/feedback/entities/feedback.entity';
import { LoginHistory } from 'src/login-history/entities/login-history.entity';
import { Notification } from 'src/notifications/entities/notification.entity';
import { PaymentHistory } from 'src/payment-history/entities/payment-history.entity';
import { Setting } from 'src/settings/entities/setting.entity';
import { StaffDetail } from 'src/staff-details/entities/staff-detail.entity';
import { UserCase } from 'src/user-case/entities/user-case.entity';
import { UserDetail } from 'src/user-details/entities/user-detail.entity';
import { UserGame } from 'src/user-game/entities/user-game.entity';
import { UserPermission } from 'src/user-permissions/entities/user-permission.entity';
import {
  Column,
  CreateDateColumn,
  Entity,
  OneToMany,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';

@Entity()
export class Account {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'int', default: 0 })
  totalCoin: number;

  @Column({ type: 'varchar', length: 100, nullable: true })
  phoneNumber: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  email: string;

  @Column({ type: 'text', nullable: true })
  password: string;

  @Column({ type: 'enum', enum: UserRole, default: UserRole.USER })
  roles: UserRole;

  // @Column({ type: 'varchar', length: 100, nullable: true })
  // deviceId: string;

  // @Column({ type: 'enum', enum: LoginType, default: LoginType.PHONE })
  // type: LoginType;

  @Column({ type: 'enum', enum: DefaultStatus, default: DefaultStatus.ACTIVE })
  status: DefaultStatus;

  @Column({ type: 'varchar', length: 5000, nullable: true })
  reason: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  referralCode: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  referredBy: string;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @OneToMany(() => LoginHistory, (loginHistory) => loginHistory.account)
  loginHistory: LoginHistory[];

  @OneToMany(() => Notification, (notification) => notification.account)
  notification: Notification[];

  @OneToMany(() => UserPermission, (userPermission) => userPermission.account)
  userPermission: UserPermission[];

  @OneToMany(() => UserDetail, (userDetail) => userDetail.account)
  userDetail: UserDetail[];

  @OneToMany(() => StaffDetail, (staffDetail) => staffDetail.account)
  staffDetail: StaffDetail[];

  @OneToMany(() => PaymentHistory, (paymentHistory) => paymentHistory.account)
  paymentHistory: PaymentHistory[];

  @OneToMany(() => Feedback, (feedback) => feedback.account)
  feedback: Feedback[];

  @OneToMany(() => ContactUs, (contactUs) => contactUs.account)
  contactUs: ContactUs[];

  @OneToMany(() => UserGame, (userGame) => userGame.account)
  userGame: UserGame[];

  @OneToMany(() => UserCase, (userCase) => userCase.account)
  userCase: UserCase[];
}
