import { CacheModule } from '@nestjs/cache-manager';
import { Module } from '@nestjs/common';
import { ConfigModule } from '@nestjs/config';
import { TypeOrmModule } from '@nestjs/typeorm';

import { ServeStaticModule } from '@nestjs/serve-static';
import { join } from 'path';
import { AccountModule } from './account/account.module';
import { AppController } from './app.controller';
import { AppService } from './app.service';
import { AuthModule } from './auth/auth.module';
import { DashboardModule } from './dashboard/dashboard.module';
import { MenusModule } from './menus/menus.module';
import { NotificationsModule } from './notifications/notifications.module';
import { PagesModule } from './pages/pages.module';
import { PermissionsModule } from './permissions/permissions.module';
import { SettingsModule } from './settings/settings.module';
import { UserDetailsModule } from './user-details/user-details.module';
import { UserPermissionsModule } from './user-permissions/user-permissions.module';
import { NodeMailerModule } from './node-mailer/node-mailer.module';
import { StaffDetailsModule } from './staff-details/staff-details.module';
import { LoginHistoryModule } from './login-history/login-history.module';
import { CityModule } from './city/city.module';
import { PaymentHistoryModule } from './payment-history/payment-history.module';
import { NotifyModule } from './notify/notify.module';
import { ContactUsModule } from './contact-us/contact-us.module';
import { FeedbackModule } from './feedback/feedback.module';
import { AvatarModule } from './avatar/avatar.module';
import { FeedbackModuleModule } from './feedback-module/feedback-module.module';
import { FeedbackIssueModule } from './feedback-issue/feedback-issue.module';
import { FeedbackReplyModule } from './feedback-reply/feedback-reply.module';
import { GameModule } from './game/game.module';
import { CaseModule } from './case/case.module';
import { CategoryModule } from './category/category.module';
import { UserGameModule } from './user-game/user-game.module';
import { UserCaseModule } from './user-case/user-case.module';

@Module({
  imports: [
    ConfigModule.forRoot(),
    ServeStaticModule.forRoot({
      rootPath: join(__dirname, '..', 'uploads'), // Path to your uploads directory
      serveRoot: '/uploads', // The URL path to access the files
    }),
    TypeOrmModule.forRoot({
      type: 'mysql',
      host: process.env.CLU_DB_HOST,
      port: Number(process.env.CLU_DB_PORT),
      username: process.env.CLU_USER_NAME,
      password: process.env.CLU_DB_PASS,
      database: process.env.CLU_DB_NAME,
      entities: [__dirname + '/**/*.entity{.ts,.js}'],
      synchronize: false,
    }),
    CacheModule.register({
      isGlobal: true,
    }),
    AuthModule,
    AccountModule,
    DashboardModule,
    SettingsModule,
    MenusModule,
    NotificationsModule,
    PermissionsModule,
    UserPermissionsModule,
    UserDetailsModule,
    PagesModule,
    NodeMailerModule,
    StaffDetailsModule,
    LoginHistoryModule,
    CityModule,
    PaymentHistoryModule,
    NotifyModule,
    ContactUsModule,
    FeedbackModule,
    AvatarModule,
    FeedbackModuleModule,
    FeedbackIssueModule,
    FeedbackReplyModule,
    GameModule,
    CaseModule,
    CategoryModule,
    UserGameModule,
    UserCaseModule,
  ],
  controllers: [AppController],
  providers: [AppService],
})
export class AppModule {}
