import { Body, Controller, Post } from '@nestjs/common';
import { AuthService } from './auth.service';
import {
  AdminSigninDto,
  MemberSigninDto,
  OtpDto,
  StaffLoginDto,
  VerifyOtpDto,
} from './dto/login.dto';

@Controller('auth')
export class AuthController {
  constructor(private readonly authService: AuthService) {}

  @Post('admin/login')
  adminLogin(@Body() dto: AdminSigninDto) {
    return this.authService.adminLogin(dto.loginId, dto.password);
  }

  @Post('user/login')
  userLogin(@Body() dto: MemberSigninDto) {
    return this.authService.userLogin(dto);
  }

  @Post('user/verify')
  userVerifyOtp(@Body() dto: OtpDto) {
    return this.authService.userVerifyOtp(dto);
  }
}
