import { Type } from 'class-transformer';
import {
  IsEnum,
  IsNotEmpty,
  IsNumber,
  IsOptional,
  IsString,
  Max,
  MaxLength,
  Min,
  MinLength,
} from 'class-validator';
import { DefaultStatus, Gender } from 'src/enum';

export class CreateAvatarDto {
  @IsNotEmpty()
  avatarName: string;

  @IsNotEmpty()
  @IsEnum(Gender)
  avatarGender: Gender;
}

export class AvatarPaginationDto {
  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(10)
  @Max(100)
  limit: number;

  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(0)
  offset: number;

  @IsOptional()
  @IsString()
  @MinLength(0)
  @MaxLength(100)
  keyword: string;

  @IsOptional()
  status: DefaultStatus;

  @IsOptional()
  avatarGender: Gender
}
