import { Type } from 'class-transformer';
import { IsNotEmpty, IsNumber, IsOptional, IsString, Max, MaxLength, Min, MinLength } from 'class-validator';

export class CreateCaseDto {
  @IsNotEmpty()
  gameId: string;

  @IsNotEmpty()
  question: string;

  @IsOptional()
  hint: string;

  @IsOptional()
  ans1: string;

  @IsOptional()
  ans2: string;

  @IsOptional()
  ans3: string;

  @IsOptional()
  ans4: string;

  @IsOptional()
  correctAnsNum: string;

  @IsNotEmpty()
  @Type(() => Number)
  winPoint: number;
}

export class CasePaginationDto {
  @IsNotEmpty()
    @Type(() => Number)
    @IsNumber()
    @Min(10)
    @Max(100)
    limit: number;
  
    @IsNotEmpty()
    @Type(() => Number)
    @IsNumber()
    @Min(0)
    offset: number;
  
    @IsOptional()
    @IsString()
    @MinLength(0)
    @MaxLength(100)
    keyword: string;
}
