export enum UserRole {
  ADMIN = 'ADMIN',
  // BUSINESS = 'BUSINESS',
  USER = 'USER',
  STAFF = 'STAFF',
}

export enum StaffRole {
  AUDITOR = 'AUDITOR',
  MANAGER = 'MANAGER',
  CO_ORDINATOR = 'CO-ORDINATOR',
  STAFF = 'STAFF',
}

export enum DefaultStatus {
  ACTIVE = 'ACTIVE',
  DEACTIVE = 'DEACTIVE',
  DELETED = 'DELETED',
  SUSPENDED = 'SUSPENDED',
  PENDING = 'PENDING',
}

export enum ReviewStatus {
  ACTIVE = 'ACTIVE',
  DELETED = 'DELETED',
}

export enum AIType {
  ACTIVE = 'ACTIVE',
  INACTIVE = 'INACTIVE',
}

export enum QnAStatus {
  YES = 'YES',
  NO = 'NO',
  DELETED = 'DELETED',
}

export enum ContactUsStatus {
  PENDING = 'PENDING',
  REPLIED = 'REPLIED',
}

export enum PermissionAction {
  CREATE = 'Create',
  READ = 'Read',
  UPDATE = 'Update',
  DELETE = 'Delete',
}

export enum LogType {
  LOGIN = 'IN',
  LOGOUT = 'OUT',
}

export enum RedirectType {
  PRODUCT = 'PRODUCT',
  VENDOR = 'VENDOR',
}

export enum PageType {
  TERMS_AND_CONDITIONS = 'TERMS & CONDITIONS',
  PRIVACY_POLICY = 'PRIVACY POLICY',
  APP_POLICY = 'APP POLICY',
  DATA_POLICY = 'DATA POLICY',
  REWARD_POLICY = 'REWARD POLICY',
  WITHDRAWAL_POLICY = 'WITHDRAWAL POLICY',
  OTHERS_POLICY = 'OTHERS POLICY',
  GAME_RULES = 'GAME RULES',
  REWARD_RULES = 'REWARD RULES',
}

export enum NotificationType {
  // ALL FOR ADMIN AND STAFF
  // NEW_PRODUCT = 'NEW PRODUCT',
  // NEW_ACCOUNT = 'NEW ACCOUNT',
  // CONTACT_US = 'CONTACT US',
  // QNA = 'QNA',
  // FEEDBACK = 'FEEDBACK',
  // INVOICE = 'INVOICE',
  // STAFF = 'STAFF',
  // TICKET = 'TICKET',

  // ALL FOR VENDOR
  // PRODUCT = 'PRODUCT',
  // PRODUCT_VIEW = 'PRODUCT VIEW',
  // VENDOR_RATING = 'VENDOR RATING',
  // VENDOR_ACCOUNT = 'VENDOR ACCOUNT',
  // VENDOR_INVOICE = 'VENDOR INVOICE',
  // VENDOR_PAYMENT = 'VENDOR PAYMENT',
  // VENDOR_TICKET = 'VENDOR TICKET',

  // ALL FOR USER
  // USER_PRODUCT = 'USER PRODUCT',
  // USER_ACCOUNT = 'USER ACCOUNT',
  // USER_INVOICE = 'USER INVOICE',
  // USER_PAYMENT = 'USER PAYMENT',
  // USER_TICKET = 'USER TICKET',
  // OFFER = 'OFFER',

  // FOR ALL
  LOGIN = 'LOGIN',
}

export enum YNStatus {
  All = 'All',
  YES = 'Yes',
  NO = 'No',
}

export enum RatingShortStatus {
  ASC = 'ASC',
  DESC = 'DESC',
  ALL = 'ALL',
}

export enum LoginType {
  FACEBOOK = 'FACEBOOK',
  GOOGLE = 'GOOGLE',
  EMAIL = 'EMAIL',
  PHONE = 'PHONE',
  GUEST = 'GUEST',
}

export enum ADType {
  ASC = 'ASC',
  DESC = 'DESC',
  NONE = '',
}

export enum Gender {
  MALE = 'MALE',
  FEMALE = 'FEMALE',
  BOTH = 'BOTH',
}

export enum PaymentStatus {
  PENDING = 'PENDING',
  COMPLETED = 'COMPLETED',
  ALL = 'ALL',
  REFUNDED = 'REFUNDED',
  CANCELLED = 'CANCELLED',
  FAILED = 'FAILED',
}

export enum PaymentType {
  PHONE_PE = 'Phone Pe',
  RAZOR_PAY = 'Razor Pay',
}

export enum WalletType {
  PENDING = 'Pending',
  CREDIT = 'Credit',
  DEBIT = 'Debit',
}

export enum DWType {
  WITHDRAW = 'Withdraw',
}

export enum SubscriptionStatus {
  COMPLETED = 'COMPLETED',
  PENDING = 'PENDING',
}

export enum MasterPaymentMode {
  CASH = 'CASH',
  BANK_TRANSFER = 'BANK TRANSFER',
}

export enum FeedbackStatus {
  PENDING = 'PENDING',
  RESOLVED = 'RESOLVED',
  CLOSED = 'CLOSED',
}

export enum GameStatus {
  LOCKED = 'LOCKED',
  OPENED = 'OPENED',
}

export enum HintStatus {
  TRUE = 'TRUE',
  FALSE = 'FALSE',
}

export enum CasePassStatus {
  ATTEMPTED = 'ATTEMPTED',
  ELEMINATED = 'ELEMINATED',
  SKIP = 'SKIP',
}

export enum PlayGameStatus {
  PLAYING = 'PLAYING',
  IN_COMPLETED = 'IN_COMPLETED',
  COMPLETED = 'COMPLETED',
}

export enum GameType {
  C1 = 'C1',
  C2 = 'C2',
  C3 = 'C3',
  C4 = 'C4',
}
