import { Module } from '@nestjs/common';
import { FeedbackIssueService } from './feedback-issue.service';
import { FeedbackIssueController } from './feedback-issue.controller';
import { FeedbackIssue } from './entities/feedback-issue.entity';
import { TypeOrmModule } from '@nestjs/typeorm';
import { AuthModule } from 'src/auth/auth.module';

@Module({
  imports: [TypeOrmModule.forFeature([FeedbackIssue]), AuthModule],
  controllers: [FeedbackIssueController],
  providers: [FeedbackIssueService],
})
export class FeedbackIssueModule {}
