import {
  Controller,
  Get,
  Post,
  Body,
  Patch,
  Param,
  Delete,
  UseGuards,
  Query,
} from '@nestjs/common';
import { FeedbackModuleService } from './feedback-module.service';
import { CreateFeedbackModuleDto } from './dto/create-feedback-module.dto';
import { UpdateFeedbackModuleDto } from './dto/update-feedback-module.dto';
import { AuthGuard } from '@nestjs/passport';
import { Roles } from 'src/auth/decorators/roles.decorator';
import { PermissionsGuard } from 'src/auth/guards/permissions.guard';
import { RolesGuard } from 'src/auth/guards/roles.guard';
import { UserRole } from 'src/enum';
import { CommonPaginationDto } from 'src/common/dto/common-pagination.dto';

@Controller('feedback-module')
export class FeedbackModuleController {
  constructor(private readonly feedbackModuleService: FeedbackModuleService) {}

  @Post()
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN)
  create(@Body() dto: CreateFeedbackModuleDto) {
    return this.feedbackModuleService.create(dto);
  }

  @Get('list')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN)
  findAll(@Query() dto: CommonPaginationDto) {
    return this.feedbackModuleService.findAll(dto);
  }

  @Get('user/list')
  find() {
    return this.feedbackModuleService.find();
  }

  @Patch('update/:id')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN)
  update(@Param('id') id: string, @Body() dto: CreateFeedbackModuleDto) {
    return this.feedbackModuleService.update(id, dto);
  }

  @Delete('remove/:id')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN)
  remove(@Param('id') id: string) {
    return this.feedbackModuleService.remove(id);
  }
}
