import { Type } from 'class-transformer';
import {
  IsEnum,
  IsNotEmpty,
  IsNumber,
  IsOptional,
  IsString,
  Max,
  MaxLength,
  Min,
  MinLength,
} from 'class-validator';
import { DefaultStatus, GameType } from 'src/enum';

export class CreateGameDto {
  @IsNotEmpty()
  categoryId: string;

  @IsNotEmpty()
  @IsString()
  @MinLength(1)
  @MaxLength(255)
  gameName: string;

  @IsNotEmpty()
  @IsString()
  @MinLength(1)
  @MaxLength(5000)
  gameDesc: string;

  @IsOptional()
  gameOpenTimer: string;

  @IsNotEmpty()
  resultTimer: string;

  @IsNotEmpty()
  type: GameType;
}

export class GamePaginationDto {
  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(10)
  @Max(100)
  limit: number;

  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(0)
  offset: number;

  @IsOptional()
  @IsString()
  @MinLength(0)
  @MaxLength(100)
  keyword: string;

  @IsOptional()
  categoryId: string;

  @IsOptional()
  status: DefaultStatus;
}
