import { MailerService } from '@nestjs-modules/mailer';
import { Injectable } from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import * as nodemailer from 'nodemailer';
import { DefaultStatus } from 'src/enum';

@Injectable()
export class NodeMailerService {
  constructor(
    // private readonly mailService: MailerService,
  ) {}

  async sendOtpInMail(email, otp, businessAccId: string) {
    if (!email || !businessAccId) {
      return false;
    }
    try {
      const smtpConfig = await this.getSmtpConfigOfBusiness(businessAccId);
      const transporter = nodemailer.createTransport({
        host: 'mail.momentsconstruction.com',
        port: '465',
        secure: 1,
        auth: {
          user: 'no-reply-mail@momentsconstruction.com',
          pass: '&#?;HOb(vLq9',
        },
        // tls: {
        //   rejectUnauthorized: true,
        // },
      });
      await transporter.sendMail({
        from: '"No Reply" <no-reply-mail@momentsconstruction.com>',
        to: email,
        subject: 'Login OTP',
        html: `
              <!DOCTYPE html>
      <html lang="en">
        <head>
          <meta charset="utf-8" />
          <meta name="viewport" content="width=device-width, initial-scale=1" />
          <title>OTP Email Template</title>
          <link
            href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css"
            rel="stylesheet"
            integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH"
            crossorigin="anonymous"
          />
          <link
            rel="stylesheet"
            href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css"
          />

          <link rel="stylesheet" href="/style.css" />
          <style>
            body {
              font-family: Arial, sans-serif;
              background-color: #f4f4f4;
              padding: 0;
              margin: 0;
            }
            .container-sec {
              background-color: #ffffff;
              border-radius: 8px;
              padding: 20px;
              margin-top: 30px;
              box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
              max-width: 600px;
            }
            .otp-code {
              font-size: 24px;
              font-weight: bold;
              background-color: #f8f9fa;
              padding: 15px;
              text-align: center;
              border-radius: 8px;
              border: 1px dashed #007bff;
              color: #007bff;
            }
            .btn-verify {
              display: inline-block;
              padding: 10px 20px;
              color: #ffffff;
              background-color: #007bff;
              border-radius: 6px;
              text-decoration: none;
              font-weight: bold;
            }
            .footer-text {
              color: #6c757d;
              font-size: 14px;
              text-align: center;
              margin-top: 20px;
            }
            .footer-text a {
              color: #007bff;
              text-decoration: none;
            }
            .otp-lock {
              color: #333;
              font-size: 80px;
            }
            .welcome-section {
              background: #144fa9db;
              padding: 30px;
              border-radius: 4px;
              color: #fff;
              font-size: 20px;
              margin: 20px 0px;
            }
            .welcome-text {
              font-family: monospace;
            }
            .app-name {
              font-size: 30px;
              font-weight: 800;
              margin: 7px 0px;
            }
            .verify-text {
              margin-top: 25px;
              font-size: 25px;
              letter-spacing: 3px;
            }
            i.fas.fa-envelope-open {
              font-size: 35px !important;
              color: #ffffff;
            }
          </style>
        </head>

        <body>
          <div class="container-sec">
            <div class="text-center">
              <div class="welcome-section">
                <div class="verify-text">Please Verify Your Email Address</div>
                <div class="email-icon">
                  <i class="fas fa-envelope-open"></i>
                </div>
              </div>
              <h2>Dear Customer</h2>
              <p>Your One-Time Password (OTP) for verification is:</p>
              <div class="otp-code">${otp}</div>
              <p class="mt-4">
                Please use this OTP to complete your verification. The OTP is valid
                for the next 10 minutes.
              </p>
            </div>
            <div class="footer-text">
              <p>Thank you,<br />Privilege Team</p>
            </div>
          </div>

          <!-- <script
            src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"
            integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz"
            crossorigin="anonymous"
          ></script> -->
        </body>
      </html>

            `,
      });
      return true;
    } catch (error) {
      console.log(error);
      return false;
    }
  }

  private async getSmtpConfigOfBusiness(businessAccId: string) {
    // const emailCred = await this.busiEmailRepo.findOne({
    //   where: { accountId: businessAccId, status: DefaultStatus.ACTIVE },
    // });
    // return {
    //   host: emailCred.smtpHost,
    //   port: emailCred.smtpPort,
    //   secure: emailCred.secure,
    //   user: emailCred.username,
    //   pass: emailCred.password,
    //   from: emailCred.from,
    // };
  }
}
