import { Account } from 'src/account/entities/account.entity';
import { Gender, StaffRole } from 'src/enum';
import {
  BeforeInsert,
  Column,
  CreateDateColumn,
  Entity,
  ManyToOne,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';

@Entity()
export class StaffDetail {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  staffId: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  salutation: string;

  @Column({ type: 'enum', enum: Gender, default: Gender.MALE })
  gender: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  fName: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  lName: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  mobile: string;

  @Column({ type: 'enum', enum: StaffRole, default: StaffRole.STAFF })
  staffRole: StaffRole;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @Column({ type: 'uuid', nullable: true })
  accountId: string;

  @ManyToOne(() => Account, (account) => account.staffDetail, {
    cascade: true,
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  account: Account[];
}
