import { Account } from 'src/account/entities/account.entity';
import { Avatar } from 'src/avatar/entities/avatar.entity';
import { City } from 'src/city/entities/city.entity';
import { DefaultStatus, Gender } from 'src/enum';
import { PaymentHistory } from 'src/payment-history/entities/payment-history.entity';
import {
  Column,
  CreateDateColumn,
  Entity,
  ManyToOne,
  OneToMany,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';

@Entity()
export class UserDetail {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'uuid', nullable: true })
  avatarId: string;

  @Column({ type: 'uuid', nullable: true })
  cityId: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  name: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  userName: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  dob: string;

  @Column({ type: 'enum', enum: Gender, nullable: true })
  gender: Gender;
  
  @Column({ type: 'varchar', length: 100, nullable: true })
  email: string;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @Column({ type: 'uuid', nullable: true })
  accountId: string;

  @ManyToOne(() => Account, (account) => account.userDetail, {
    cascade: true,
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  account: Account[];

  @ManyToOne(() => Avatar, (avatar) => avatar.userDetail, {
    cascade: true,
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  avatar: Avatar[];

  @ManyToOne(() => City, (city) => city.userDetail, {
    cascade: true,
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  city: City[];

  @OneToMany(
    () => PaymentHistory,
    (paymentHistory) => paymentHistory.userDetail,
  )
  paymentHistory: PaymentHistory[];
}
