import { Body, Controller, Get, Param, Patch, UseGuards } from '@nestjs/common';
import { AuthGuard } from '@nestjs/passport';
import { Account } from 'src/account/entities/account.entity';
import { CurrentUser } from 'src/auth/decorators/current-user.decorator';
import { Roles } from 'src/auth/decorators/roles.decorator';
import { RolesGuard } from 'src/auth/guards/roles.guard';
import { UserRole } from 'src/enum';
import { RegisterUserDetailDto } from './dto/update-user-details';
import { UserDetailsService } from './user-details.service';
import { PermissionsGuard } from 'src/auth/guards/permissions.guard';

@Controller('user-details')
export class UserDetailsController {
  constructor(private readonly userDetailsService: UserDetailsService) {}

  @Get('check-userName/:userName')
  checkUserName(@Param('userName') userName: string){
    return this.userDetailsService.checkUserName(userName)
  }

  @Patch('register')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.USER)
  register(@Body() dto: RegisterUserDetailDto, @CurrentUser() user: Account) {
    dto.accountId = user.id;
    return this.userDetailsService.register(dto, user.id);
  }

  @Patch('update-user/:accountId')
  @UseGuards(AuthGuard('jwt'), RolesGuard, PermissionsGuard)
  @Roles(...Object.values(UserRole))
  // @CheckPermissions([PermissionAction.UPDATE, 'user_detail'])
  updateUser(
    @Param('accountId') accountId: string,
    @Body() dto: RegisterUserDetailDto,
  ) {
    return this.userDetailsService.register(dto, accountId);
  }
}
