import {
  ConflictException,
  Injectable,
  NotFoundException,
} from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import { RegisterUserDetailDto } from './dto/update-user-details';
import { UserDetail } from './entities/user-detail.entity';
import { NodeMailerService } from 'src/node-mailer/node-mailer.service';
import { unlink } from 'fs/promises';
import { join } from 'path';
import { Account } from 'src/account/entities/account.entity';

@Injectable()
export class UserDetailsService {
  constructor(
    @InjectRepository(UserDetail) private readonly repo: Repository<UserDetail>,
    @InjectRepository(Account) private readonly accRepo: Repository<Account>,
    private readonly nodeMailerService: NodeMailerService,
  ) {}

  async findOne(id: string) {
    const result = await this.repo.findOne({ where: { accountId: id } });
    if (!result) {
      throw new NotFoundException('User not found!');
    }
    return result;
  }

  async checkUserName(userName: string) {
    const result = await this.repo.findOne({ where: { userName } });
    if (result) {
      throw new ConflictException(`${userName} -> username already exists!`);
    }
    return { success: true, message: 'You can use this username.' };
  }

  async register(dto: RegisterUserDetailDto, accountId: string) {
    const result = await this.repo.findOne({ where: { accountId: accountId } });
    if (!result) {
      throw new NotFoundException('User not found!');
    }

    const acc = await this.accRepo.findOne({ where: { id: accountId } });
    if (acc && (!acc.referralCode || acc.referralCode.trim() === '')) {
      const randomNumber = Math.floor(1000 + Math.random() * 9000);
      const newCode =
        dto.name.slice(0, 3).toUpperCase() +
        dto.userName.slice(0, 3).toUpperCase() +
        dto.dob.slice(-2) +
        randomNumber.toString();
      acc.referralCode = newCode;
      await this.accRepo.save(acc);
    }
    const obj = Object.assign(result, dto);
    return this.repo.save(obj);
  }
}
