import { Account } from 'src/account/entities/account.entity';
import { PlayGameStatus } from 'src/enum';
import { Game } from 'src/game/entities/game.entity';
import {
  Column,
  CreateDateColumn,
  Entity,
  ManyToOne,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';

@Entity()
export class UserGame {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'uuid', nullable: true })
  accountId: string;

  @Column({ type: 'uuid', nullable: true })
  gameId: string;

  @Column({ type: 'int', default: 0, nullable: true }) //In Seconds
  totalDuration: number;

  @Column({ type: 'int', default: 0, nullable: true })
  earnedPoint: number;

  @Column({ type: 'enum', enum: PlayGameStatus, default: PlayGameStatus.PLAYING })
  status: PlayGameStatus;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @ManyToOne(() => Account, (account) => account.userGame, {
    cascade: true,
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  account: Account[];

  @ManyToOne(() => Game, (game) => game.userGame, {
    cascade: true,
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  game: Game[];
}
