import {
  Controller,
  Get,
  Post,
  Body,
  Patch,
  Param,
  Delete,
  UseGuards,
} from '@nestjs/common';
import { UserGameService } from './user-game.service';
import { CreateUserGameDto } from './dto/create-user-game.dto';
import { UpdateUserGameDto } from './dto/update-user-game.dto';
import { AuthGuard } from '@nestjs/passport';
import { Roles } from 'src/auth/decorators/roles.decorator';
import { RolesGuard } from 'src/auth/guards/roles.guard';
import { UserRole } from 'src/enum';
import { CurrentUser } from 'src/auth/decorators/current-user.decorator';
import { Account } from 'src/account/entities/account.entity';

@Controller('user-game')
export class UserGameController {
  constructor(private readonly userGameService: UserGameService) {}

  @Post()
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.USER)
  create(@Body() dto: CreateUserGameDto, @CurrentUser() user: Account) {
    return this.userGameService.create(dto, user.id);
  }

  @Get('detail/:gameId')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.USER)
  findDetail(@Param('gameId') gameId: string, @CurrentUser() user: Account) {
    return this.userGameService.findDetail(gameId, user.id);
  }

  @Get(':id')
  findOne(@Param('id') id: string) {
    return this.userGameService.findOne(+id);
  }

  @Patch(':id')
  update(
    @Param('id') id: string,
    @Body() updateUserGameDto: UpdateUserGameDto,
  ) {
    return this.userGameService.update(+id, updateUserGameDto);
  }

  @Delete(':id')
  remove(@Param('id') id: string) {
    return this.userGameService.remove(+id);
  }
}
