import { BadRequestException, Injectable } from '@nestjs/common';
import { CreateUserGameDto } from './dto/create-user-game.dto';
import { UpdateUserGameDto } from './dto/update-user-game.dto';
import { InjectRepository } from '@nestjs/typeorm';
import { UserGame } from './entities/user-game.entity';
import { Repository } from 'typeorm';
import { PlayGameStatus } from 'src/enum';
import { Account } from 'src/account/entities/account.entity';
import { Game } from 'src/game/entities/game.entity';

@Injectable()
export class UserGameService {
  constructor(
    @InjectRepository(UserGame) private readonly repo: Repository<UserGame>,
    @InjectRepository(Account) private readonly accRepo: Repository<Account>,
    @InjectRepository(Game) private readonly gameRepo: Repository<Game>,
  ) {}

  async create(dto: CreateUserGameDto, accountId: string) {
    const result = await this.repo.findOne({
      where: { accountId, gameId: dto.gameId },
    });
    if (!result) {
      const obj = Object.assign({
        accountId: accountId,
        gameId: dto.gameId,
        totalDuration: null,
        status: PlayGameStatus.PLAYING,
      });
      return this.repo.save(obj);
    } else {
      if (!dto.totalDuration) {
        const obj = Object.assign(result, {
          totalDuration: result.totalDuration,
          status: dto.status,
        });
        return this.repo.save(obj);
      }
      if (dto.totalDuration) {
        const obj = Object.assign(result, {
          earnedPoint: dto.earnedPoint,
          totalDuration: result.totalDuration + dto.totalDuration,
          status: dto.status,
        });
        return this.repo.save(obj);
      }
    }
  }

  async findDetail(gameId: string, accountId: string) {
    const result = await this.repo.findOne({
      select: ['id', 'totalDuration', 'earnedPoint', 'createdAt', 'status'],
      where: { accountId, gameId },
    });
    if (!result) {
      throw new BadRequestException('Game not played yet!');
    }
    return result;
  }

  findOne(id: number) {
    return `This action returns a #${id} userGame`;
  }

  update(id: number, updateUserGameDto: UpdateUserGameDto) {
    return `This action updates a #${id} userGame`;
  }

  remove(id: number) {
    return `This action removes a #${id} userGame`;
  }
}
