import axios from 'axios';

/** Utility function to send SMS using Axon SMS API */
export async function sendOtp(
  phoneNumber: string,
  otp: number,
  smsConfig: { smsApiKey: string; smsSenderId: string; smsRoute: string },
): Promise<boolean> {
  try {
    const baseUrl = 'http://axonsms.com/api/mt/SendSMS';
    const params = new URLSearchParams({
      APIKey: smsConfig.smsApiKey,
      senderid: smsConfig.smsSenderId,
      channel: '2',
      DCS: '0',
      flashsms: '0',
      number: phoneNumber,
      text: `Use this OTP ${otp} for registration. - BUDCEO	`,
      route: smsConfig.smsRoute,
    });

    const response = await fetch(`${baseUrl}?${params.toString()}`);
    if (!response.ok) {
      throw new Error(`SMS API returned status: ${response.status}`);
    }
    return true;
  } catch (error) {
    return false;
  }
}

export async function sendSMS(
  phone: number,
  message: string,
  templateId: number,
) {
  try {
    const msg = encodeURIComponent(message);

    const payload = await axios.get(
      `http://nimbusit.biz/api/SmsApi/SendSingleApi?UserID=${process.env.PV_OTP_USERID}&Password=${process.env.PV_OTP_PASSWORD}&SenderID=${process.env.CLU_OTP_SENDERID}&Phno=${phone}&Msg=${msg}&EntityID=${process.env.PV_OTP_ENTITYID}&TemplateID=${templateId}`,
      {
        headers: {},
      },
    );
    if (payload.data.Status == 'OK') {
      return true;
    } else {
      return null;
    }
  } catch (error) {
    return null;
  }
}
